import React, { memo } from 'react';
import { Icon } from 'bebo-ui';

import css from './Download.module.scss';

const LandingDownload = memo(() => {
  return (
    <section className={css.download}>
      <h2>Start playing now for free</h2>
      <ul className={css.downloadOptions}>
        <li className={css.downloadOption}>
          <Icon icon="win10" size={100} />
          <p>Windows</p>
          <div className={css.downloadButtonDisabled}>Coming Soon</div>
        </li>
        <li className={css.downloadOption}>
          <Icon icon="xbox" size={100} />
          <p>XBox One</p>
          <div className={css.downloadButtonDisabled}>Coming Soon</div>
        </li>
        <li className={css.downloadOption}>
          <Icon icon="ps4" size={100} />
          <p>PS4</p>
          <div className={css.downloadButtonDisabled}>Coming Soon</div>
        </li>
      </ul>
    </section>
  );
});

export default LandingDownload;
