import React, { memo } from 'react';
import cx from 'classnames';

import useTrack from 'hooks/useTrack';
import useLoadTimes from 'hooks/useLoadTimes';

import Header from 'components/header';

import LandingHero from './components/Landing/Hero';
import LandingStates from './components/Landing/States';
import LandingTournaments from './components/Landing/Tournaments';
import LandingRecognition from './components/Landing/Recognition';
import LandingDownload from './components/Landing/Download';
import Footer from 'components/footer';

import css from './home.module.scss';

const Home = memo(() => {
  useLoadTimes();
  useTrack('landing');
  useTrack('signup_funnel', 'home');

  return (
    <section className={cx(css.container, 'bebo-landing web')}>
      <Header background="#141414" inverse />
      <LandingHero />
      <LandingStates />
      <LandingTournaments />
      <LandingRecognition />
      <LandingDownload />
      <Footer inverse />
    </section>
  );
});

export default Home;
