import React, { memo } from 'react';
import cx from 'classnames';
import useTrack from 'hooks/useTrack';
import useLoadTimes from 'hooks/useLoadTimes';
import screenshotImg from './assets/MatchScreenshot.png';
import Header from 'components/header';
import Footer from 'components/footer';

import css from './how-to.module.scss';

const HowTo = memo(() => {
  useLoadTimes();
  useTrack('how-to');

  return (
    <div className={cx(css.container, 'bebo-landing web')}>
      <Header background="#141414" inverse />
      <div className={css.content}>
        <header className={css.header}>
          <h1 className={css.title}>How It Works</h1>
        </header>
        <div className={css.joinLeague}>
          <h2 className={css.joinLeagueTitle}>Join a League</h2>
          <ul className={css.leaguesList}>
            <li className={css.leagueItem}>
              <h2 className={css.leagueItemTitle}>Solos</h2>
              <span className={css.leagueItemLevel}>All Levels</span>
            </li>
            <li className={css.leagueItem}>
              <h2 className={css.leagueItemTitle}>Duos</h2>
              <span className={css.leagueItemLevel}>All Levels</span>
            </li>
            <li className={css.leagueItem}>
              <h2 className={css.leagueItemTitle}>T100</h2>
              <span className={css.leagueItemLevel}>Pro Level</span>
            </li>
          </ul>
          <p className={css.leagueDescription}>
            Bebo offers HIGH SCHOOL players a way to play competitively.
            <br />
            <br />
            Compete against players your age & in your state.
          </p>
        </div>
        <div className={css.playMatches}>
          <div className={css.sectionDivider}>
            <span>Then Do This</span>
          </div>
          <div className={css.playMatchesContent}>
            <h2 className={css.playMatchesTitle}>Play 5 Weekly Matches</h2>
            <img src={screenshotImg} alt="Match Screenshot" />
          </div>
        </div>
        <div className={css.tournaments}>
          <div className={css.sectionDivider}>
            <span>To Qualify For...</span>
          </div>
          <h2 className={css.tournamentsTitle}>Tournaments</h2>
          <div className={css.tournamentsContent}>
            <div className={css.tournamentsContentLeft}>
              <h2>2X PER MONTH</h2>
              <p>
                Midseason Tournnament
                <br />
                Season Championship
              </p>
            </div>
            <div className={css.tournamentsContentRight}>
              <h2>$3000</h2>
              <p>
                Cash &<br />
                Prize Pools
              </p>
            </div>
          </div>
        </div>
        <div className={css.signUp}>
          <div className={css.sectionDivider}>
            <span>Ready to Play?</span>
          </div>
        </div>
      </div>
      <Footer inverse />
    </div>
  );
});

export default HowTo;
