import React, { memo, useEffect, useState } from 'react';

import { FullSizeLoader } from 'bebo-ui';

import { Redirect } from '@reach/router';

import { GET } from 'classes/socket';
import { getSingleResult } from 'scripts/utils';

import { setUtmValues } from 'scripts/analytics';

import useStorage from 'hooks/useStorage';

import useTrack from 'hooks/useTrack';
import useLoadTimes from 'hooks/useLoadTimes';

import InviteScreen from 'components/invite';

const Invite = memo(({ code }) => {
  useLoadTimes();
  useTrack('signup_funnel', 'invite', { invite_code_tx: code });

  const [inviteCode, setInviteCode] = useStorage('invite-code', code);
  const [codeData, setCodeData] = useState(null);
  const [gotCode, setGotCode] = useState(false);

  useEffect(() => {
    if (code) {
      GET('/invite', { code }, { bypass: true })
        .then(response => {
          response = getSingleResult(response);
          setUtmValues(response);
          return response;
        })
        .then(combined => {
          setCodeData(combined);
          setGotCode(true);
        })
        .catch(err => {
          setGotCode(true);
        });
    }
  }, [code]);

  useEffect(() => {
    if (!inviteCode && codeData && gotCode) {
      setInviteCode(code);
    }
  }, [inviteCode, codeData, gotCode, setInviteCode, code]);

  if (!gotCode) {
    return <FullSizeLoader fixed />;
  }

  if (gotCode && !codeData) {
    return <Redirect noThrow to="/" />;
  }

  return (
    <InviteScreen
      team={codeData && codeData.team && codeData.team.name}
      league={codeData && codeData.league}
      playerName={codeData && codeData.viral_user && codeData.viral_user.username}
      playerImg={codeData && codeData.viral_user && codeData.viral_user.image_url}
    />
  );
});

export default Invite;
