import React, { useState, useEffect } from 'react';

import useActingUser from 'hooks/useActingUser';

import { Redirect } from '@reach/router';
import { FullSizeLoader } from 'bebo-ui';

import InviteController from 'controllers/invite';

import useStorage from 'hooks/useStorage';
import useUserSettings from 'hooks/useUserSettings';
import useLoadTimes from 'hooks/useLoadTimes';

const JoinContainer = () => {
  useLoadTimes();
  const actingUser = useActingUser();

  const [inviteCode, setInviteCode] = useStorage('invite-code', false);
  const [, setPreviousLeagueId] = useUserSettings('last-league');
  const [sentInviteCode, setSentInviteCode] = useState(false);

  useEffect(() => {
    if (!inviteCode || !actingUser || sentInviteCode) {
      return;
    }
    InviteController.postCode(inviteCode)
      .then(response => {
        if (response && response.result && response.result[0] && response.result[0].league_id) {
          //below sets the `previous league id` key to the league we just successfully joined so we'll select it by default
          setPreviousLeagueId(response.result[0].league_id);
        }
        setTimeout(() => {
          setInviteCode(null);
          setSentInviteCode(true);
        }, 2000);
      })
      .catch(err => {
        console.error('*** postCode error', err);
        setTimeout(() => {
          setInviteCode(null);
          setSentInviteCode(true);
        }, 2000);
      });
    //eslint-disable-next-line
  }, [inviteCode, actingUser && actingUser.user_id]);

  if (!actingUser || (inviteCode && !sentInviteCode)) {
    return <FullSizeLoader fixed />;
  }

  if ((!actingUser.leagues || !actingUser.leagues.length) && (sentInviteCode || !inviteCode)) {
    return <Redirect noThrow to="/success" />;
  }

  return <Redirect noThrow to="/welcome" />;
};

export default JoinContainer;
