import React, { Component } from 'react';
import { Link } from '@reach/router';
import Header from 'components/header';

class AcceptableUse extends Component {
  render() {
    return (
      <div className="bebo-landing legal web">
        <Header background="#fff" />
        <section className="content">
          <article>
            <section>
              <header>
                <h1>Acceptable Use Policy</h1>
              </header>
              <p>
                Bebo is a web-based platform (bebo.com) (“Site”) offering a suite of tools for
                streamers on Twitch (“Streamers”) to optimize their streaming and their engagement
                and transactions with their followers (“Followers”) (“Service”). To preserve the
                positive experience of all our Streamers, Followers and visitors (collectively,
                “Users”), you agree that you will use the Service only in a manner consistent with
                the following Acceptable Use Policy.
              </p>

              <p>You agree not to use the Service to post or display User Content that:</p>

              <ul>
                <li>
                  creates a risk of harm, loss, physical or mental injury, emotional distress,
                  death, disability, disfigurement, or physical or mental illness to yourself, to
                  any other person, or to any animal;
                </li>
                <li>may create a risk of any other loss or damage to any person or property;</li>
                <li>
                  seeks to harm or exploit children by exposing them to inappropriate content,
                  asking for personally identifiable details or otherwise;
                </li>
                <li>violates, or encourages any conduct that violates laws or regulations;</li>
                <li>
                  contains any information or content we deem to be hateful, excessively violent,
                  harmful, abusive, racially or ethnically offensive, defamatory, infringing,
                  invasive of personal privacy or publicity rights, harassing, humiliating to other
                  people (publicly or otherwise), libelous, threatening, profane, or otherwise
                  objectionable;
                </li>
                <li>
                  contains any information or content that is illegal (including, without
                  limitation, the disclosure of insider information under securities law or of
                  another party’s trade secrets);
                </li>
                <li>
                  infringes any third party’s Intellectual Property Rights, privacy rights,
                  publicity rights, or other personal or proprietary rights;
                </li>
                <li>
                  contains any information or content that you do not have a right to make available
                  under any law or under contractual or fiduciary relationships; or
                </li>
                <li>is fraudulent, false, misleading, or deceptive.</li>
              </ul>

              <p>You agree not to engage in any of the following prohibited activities:</p>

              <ul>
                <li>
                  Use, display, mirror or frame the Service, any individual element within the
                  Service, the BEBO name, trademark, logo or other proprietary information, or the
                  layout and design of any page, without our express written consent;
                </li>
                <li>
                  Access, tamper with, or use non-public areas of the Service, our computer systems,
                  or the technical delivery systems of our providers;
                </li>
                <li>
                  Attempt to probe, scan, or test the vulnerability of any BEBO system or network or
                  breach any security or authentication measures;
                </li>
                <li>
                  Avoid, bypass, remove, deactivate, impair, descramble or otherwise circumvent any
                  technological measure implemented by BEBO or any of our providers or any other
                  third party (including another user) to protect the Service or BEBO Content;
                </li>
                <li>
                  Attempt to access or search the Service, User Content or BEBO Content or scrape or
                  download User Content or BEBO Content from the Service, or otherwise use, upload
                  content to, or create new links, reposts, or referrals in the Service through the
                  use of any engine, software, tool, agent, device or mechanism (including automated
                  scripts, spiders, robots, crawlers, data mining tools or the like) other than the
                  software and/or search agents provided by BEBO or other generally available third
                  party web browsers;
                </li>
                <li>
                  use any meta tags or other hidden text or metadata utilizing a BEBO or BEBO
                  trademark, logo, URL, or product name without BEBO’s express written consent;
                </li>
                <li>
                  Use the Service for any commercial purpose or the benefit of any third party,
                  except as otherwise explicitly permitted for you by BEBO or in any manner not
                  permitted by the Terms;
                </li>
                <li>
                  Attempt to decipher, decompile, disassemble or reverse engineer any of the
                  software used to provide the Service;
                </li>
                <li>
                  Interfere with, or attempt to interfere with, the access of any user, host or
                  network, including, without limitation, sending a virus, overloading, flooding,
                  spamming, or mail-bombing the Service;
                </li>
                <li>
                  Collect or store any personally identifiable information from the Service from
                  other users of the Service without their express permission;
                </li>
                <li>Impersonate or misrepresent your affiliation with any person or entity;</li>
                <li>Violate any applicable law or regulation; or</li>
                <li>
                  Encourage or enable any other individual to do any of the activities prohibited in
                  this Acceptable Use Policy.
                </li>
              </ul>

              <p>
                BEBO reserves the right, but is not obligated, to remove any User Content for any
                reason or for no reason, including User Content that BEBO believes violates this
                Acceptable Use Policy or its Terms of Service. BEBO may also permanently or
                temporarily terminate or suspend a User’s access to the Service without notice and
                liability for any reason, including if, in BEBO’s sole determination, a User
                violates any provision of this Acceptable Use Policy , our{' '}
                <Link to="/legal/terms">Terms of Service</Link>, or for no reason.
              </p>
            </section>
          </article>
        </section>
      </div>
    );
  }
}

AcceptableUse.displayName = 'AcceptableUse';

// Uncomment properties you need
// AcceptableUseComponent.propTypes = {};
// AcceptableUseComponent.defaultProps = {};

export default AcceptableUse;
