import React, { memo } from 'react';
import { Router, Redirect } from '@reach/router';

import AcceptableUse from './acceptable-use';
import Copyright from './copyright';
import OpenSource from './open-source';
import Privacy from './privacy';
import Terms from './terms';

import './legal.scss';

const LegalHome = memo(() => {
  return (
    <Router>
      <AcceptableUse path="acceptable-use" />
      <Copyright path="copyright" />
      <OpenSource path="opensource" />
      <Privacy path="privacy" />
      <Terms path="terms" />
      <Redirect noThrow from="/" to="terms" />
    </Router>
  );
});

export default LegalHome;
