import React, { Component } from 'react';
import { Link } from '@reach/router';
import Header from 'components/header';

class Privacy extends Component {
  render() {
    return (
      <div className="bebo-landing legal web">
        <Header background="#fff" />
        <section className="content">
          <article>
            <section>
              <header>
                <h1>Privacy Policy</h1>
              </header>
              <h2>Our Commitment to You</h2>
              <p>
                <strong>We Keep Your Personal Information Strictly Confidential.</strong> We at BEBO
                ("BEBO"), understand and respect that your privacy should always remain strictly
                under your control. It is because of this philosophy that you can be confident that
                the information you privately divulge to BEBO will not be accessible to people whom
                you have not authorized to receive it. Nor will it be sold or otherwise distributed
                to third parties without your consent, other than in accordance with this policy.
                BEBO is not a source of unwanted communications.
              </p>
              <p>
                <strong>You Control Your Content.</strong> Bebo is a web-based platform (bebo.com)
                (“Site”) offering a suite of tools for streamers on Twitch (“Streamers”) to optimize
                their streaming and their engagement and transactions with their followers
                (“Followers”).
              </p>
              <h3>Frequently Asked Questions</h3>
              <ol>
                <li>
                  <a href="#p1">
                    What personal details do you need to know? How do you store this information?
                  </a>
                </li>
                <li>
                  <a href="#p2">
                    When is my information given out? Can third parties access my information?
                  </a>
                </li>
                <li>
                  <a href="#p3">Do you sell my information to third parties?</a>
                </li>
                <li>
                  <a href="#p4">Does BEBO use third party advertisers and analytics?</a>
                </li>
                <li>
                  <a href="#p5">How do you use my personal details?</a>
                </li>
                <li>
                  <a href="#p6">Will I be added to any mailing lists?</a>
                </li>
                <li>
                  <a href="#p7">Do you send unsolicited text or email messages?</a>
                </li>
                <li>
                  <a href="#p8">What do you use cookies for?</a>
                </li>
                <li>
                  <a href="#p9">How will I be notified of changes?</a>
                </li>
                <li>
                  <a href="#p10">How do I cancel my account?</a>
                </li>
                <li>
                  <a href="#p11">How do I retrieve an export of data you store about me?</a>
                </li>
                <li>
                  <a href="#p12">How do I contact you?</a>
                </li>
              </ol>
              <h4 id="p1">
                What personal details do you need to know? How do you store this information?
              </h4>
              <p>
                To register as a Streamer, we will need your full name and your email address. When
                you register we can see your IP address. This may provide us with a general location
                for you. We also learn your Twitch account name, but not your password. If you
                communicate with us by telephone for support questions or other inquiries, we will
                maintain your telephone number. As your Followers acquire and use virtual coins
                through your use of the Site, we will know how many coins you have accumulated, and
                the amount of tips you have earned on Twitch. We will see your Followers’ user names
                on Twitch. We can also see what other programs you are using to stream to Twitch.
                All of this information is stored on our cloud-based data solution.
              </p>
              <p>
                We also acquire some information from Followers, including their Twitch user names,
                their IP address if they purchase coins from us, their credit card information
                (using Stripe - https://stripe.com), the number of coins they have, and how they
                spend them. We do not store any credit card information. All other information
                collected from Followers is stored on our cloud-based data solution.
              </p>

              <h4 id="p2">
                When is my information given out? Can third parties access my information?
              </h4>
              <p>
                We will not give out any personal information without your knowledge. We will never
                provide personal information to any outside company, including advertisers. We would
                only disclose the personal information of a Streamer or Follower to cooperate with a
                criminal investigation or if we were served with a subpoena in a lawsuit. Any
                information you publicly display in your streams on Twitch or other services or in
                social media is not considered personal information in Bebo’s possession or control
                and may be considered Streamer Content as described in our{' '}
                <Link to="/legal/terms">Terms of Service</Link>.
              </p>

              <h4 id="p3">Do You sell my information to third parties?</h4>
              <p>
                No. As a matter of policy, we do not, without your consent, sell, rent or lend any
                of your personal information to third parties other than in accordance with this
                policy.
              </p>

              <h4 id="p4">Does BEBO use third party advertisers and analytics?</h4>
              <p>
                We may use third-party advertising companies to serve ads when you visit our Site.
                These companies may use information (not including your name, email address, or
                telephone number) about your visits to this and other websites in order to provide
                advertisements about goods and services of interest to you. We may collect Streamer
                or Follower activity in our analytics platform, including personal information of
                individual Streamers and Followers, but only for internal Site usage analysis.
              </p>

              <h4 id="p5">What do you use my personal details for?</h4>

              <p>
                <strong>We Use Your Information for the Following Purposes.</strong> The following
                describes some of the ways that your personal information may be used in the normal
                routine to provide our range of services to you.
              </p>
              <p>It Helps Us Provide Better Service to You. We use your personal information to:</p>
              <ul>
                <li>confirm your identity when you log in</li>
                <li>respond to your inquiries</li>
                <li>troubleshoot problems</li>
                <li>analyze Site usage and determine Streamer and Follower preferences</li>
                <li>
                  customize your experience and the Site’s and App’s content, layout, and services
                </li>
                <li>detect and protect us against error, fraud, and other criminal activity</li>
                <li>
                  enforce our <Link to="/legal/acceptable-use">Acceptable Use Policy</Link>,{' '}
                  <Link to="/legal/copyright">Copyright Policy</Link>, and related policies
                </li>
                <li>
                  pursue other purposes that may be stated at the time we collect your information.
                </li>
                <li>improve our content and product offerings</li>
                <li>inform you about offers, products, services, and updates</li>
              </ul>

              <p>
                <strong>It Helps Us Get You the Information You are Most Interested in.</strong> You
                agree that we may use your personal information to contact you and deliver
                information to you that, in some cases, are targeted to your interests, such as
                targeted banner advertisements from BEBO and third party advertisers, administrative
                notices, product offerings, and communications relevant to your use of the Site. By
                accepting the <Link to="/legal/terms">Terms of Service</Link> and{' '}
                <Link to="/legal/privacy">Privacy Policy</Link>, you expressly agree to receive this
                information. You may unsubscribe from future text notifications by unsubscribing in
                the method indicated in the notification.
              </p>
              <p>
                <strong>
                  It Helps Our Teams Operate More Efficiently to Keep the Site and App Running
                  Smoothly.
                </strong>{' '}
                We may use third parties that we refer to as internal service providers to
                facilitate or outsource one or more aspects of the business, product and service
                operations that we provide to you (e.g., analytics and email support) and therefore
                we may provide some of your personal information directly to these internal service
                providers. These internal service providers are subject to confidentiality
                agreements with us and other legal restrictions that prohibit their use of the
                information we provide them for any other purpose except to facilitate the specific
                outsourced BEBO related operation, unless you have explicitly agreed or given your
                prior permission to them for additional uses.
              </p>
              <p>
                In some instances, the internal service provider may collect information directly
                from you (such as for BEBO surveys). In these cases, you will be notified of the
                involvement of the internal service provider, and all additional information you
                provide them and their additional uses will be strictly up to you. If you provide
                additional information to an internal service provider directly, then their use of
                your personal information is governed by their applicable privacy policy.
              </p>
              <p>
                <strong>
                  It Helps Us Determine and Display the Geographic Reach of Our Service.
                </strong>{' '}
                We may use platforms that enable us to determine your location, or we may request
                permission to see your location. This helps us adapt our service to Streamers in
                diverse locations.
              </p>
              <p>
                <strong>
                  We Cooperate with Law Enforcement; General Risks of Misappropriation.
                </strong>{' '}
                We Meet Industry Standards of Privacy Protection. BEBO cooperates with law
                enforcement inquiries, as well as other third parties to enforce laws, such as:
                intellectual property rights, fraud and other rights, to help protect you and the
                BEBO service. Therefore, in response to a genuine request by law enforcement or
                other government officials relating to a criminal investigation or alleged illegal
                activity, we can disclose personal information about you. Third parties may
                unlawfully intercept or access transmissions. Therefore, although we use industry
                standard practices to protect your privacy, we do not promise, and you should not
                expect, that your personal information or private communications will always remain
                private.
              </p>
              <p>
                <strong>If we Sell our Business.</strong> It is possible that as we continue to
                develop our Site and our business, BEBO's Site, App, and/or related assets might be
                acquired. Notwithstanding any provision in this policy to the contrary, in event of
                a merger or acquisition, your personal information may be transferred to the
                acquiring entity, and become subject to the acquirer's data practices.
              </p>
              <p>
                <strong>Marketing Our Services.</strong> Our{' '}
                <Link to="/legal/terms">Terms of Service</Link> detail our license to use your
                Streamer Content (including your name, identity, likeness, and voice) for marketing
                and promotional purposes.
              </p>

              <h4 id="p6">Will I be added to any mailing lists?</h4>
              <p>
                We do not sell, rent or lend email addresses for any other purpose than in direct
                association with your use of the BEBO Site or as otherwise described in this privacy
                policy.
              </p>

              <h4 id="p7">Do you send unsolicited text or email messages?</h4>
              <p>
                BEBO will not send any unwanted information, including email. You will, however
                receive emails which form an essential part of the service.
              </p>

              <h4 id="p8">What do you use cookies for?</h4>
              <p>
                Cookies are a standard internet technology, and many major web sites use them to
                provide useful features for their members. Cookies allow us to store and retrieve
                login information on a Streamer's system. They provide us with data that we can use
                to improve our service to you. If you so choose, you can save your login or password
                so you don't have to re-enter them each time you visit our Site. Cookies themselves
                do not personally identify Streamers, although they do identify a Streamer's device.
                Most browsers are initially set up to accept cookies. If you'd prefer, you can set
                yours to refuse cookies. However, you may not be able to take full advantage of our
                Site if you do so.
              </p>

              <h4 id="p9">How will I be notified of changes?</h4>
              <p>
                We may amend this Privacy Policy at any time by posting the amended terms on the
                Site. All amended terms shall automatically be effective immediately after posting
                on the Site.
              </p>

              <h4 id="p10">How do I cancel my membership?</h4>
              <p>
                You always have the option not to become a registered Streamer or to cancel your
                account at any time. If you are a registered Streamer and no longer wish to
                participate in BEBO , please send us an email notifying us of your cancellation to{' '}
                <a href="mailto:deleteme@bebo.com">deleteme@bebo.com</a>.
              </p>
              <p>
                This action will cancel your account. You will be assured that, BEBO will not
                contact you directly at the email address or telephone number we have on record for
                you, other than to respond to requests you may make to BEBO in the future. (Please
                allow up to 10 working days for account deletion to be fully processed.)
              </p>

              <h4 id="p11">How do I retrieve an export of data you store about me?</h4>
              <p>
                You have the option to receive a full export of data BEBO has stored about you at
                any given point. To do this please send us an email notifying us of your request of
                an export to <a href="mailto:exports@bebo.com">exports@bebo.com</a>.
              </p>
              <p>
                This action will trigger an export of any piece of data BEBO has stored about you at
                the time of the request. (Please allow up to 10 working days for account deletion to
                be fully processed.)
              </p>

              <h4 id="p12">How do I contact you?</h4>
              <p>
                If you have any questions about this privacy statement, the practices of this
                website or your dealings with our Site, you can contact us by email message to{' '}
                <a href="mailto:support@bebo.com">support@bebo.com</a>, or by writing to:
              </p>
              <p>
                Customer Support,
                <br />
                BEBO
                <br />
                387 Tehama Street
                <br />
                San Francisco, CA 94103
                <br />
                <a href="mailto:support@bebo.com">support@bebo.com</a>
              </p>
            </section>
          </article>
        </section>
      </div>
    );
  }
}

Privacy.displayName = 'Privacy';

// Uncomment properties you need
// Privacy.propTypes = {};
// Privacy.defaultProps = {};

export default Privacy;
