import React, { Component } from 'react';
import { Link } from '@reach/router';
import Header from 'components/header';

class Terms extends Component {
  render() {
    return (
      <div className="bebo-landing legal web">
        <Header background="#fff" />
        <section className="content">
          <article>
            <section>
              <header>
                <h1>Terms of Service</h1>
              </header>
              <h3>These are the Services We Provide.</h3>
              <p>
                Thank you for using Bebo. We have a web-based platform (bebo.com) (“Site”) offering
                a suite of tools for streamers on Twitch (“Streamers”) to stream gameplay to their
                followers (“Followers”).
              </p>
              <h3>Who We Are and How to Reach Us.</h3>
              <p>
                Bebo is hosted by Pigs In Flight, Inc., a Delaware corporation d/b/a Bebo (“Bebo”).
                Please read these Terms of Service (“Terms”) carefully, and email us at{' '}
                <a href="mailto:support@bebo.com">support@bebo.com</a> if you have any questions. By
                accessing or using the Site, you agree to be bound by these Terms and by our{' '}
                <Link to="/legal/privacy">Privacy Policy</Link>,{' '}
                <Link to="/legal/acceptable-use">Acceptable Use Policy</Link>, and{' '}
                <Link to="/legal/copyright">Copyright Policy</Link>. These Terms apply to everyone
                who accesses the Site (Streamers, Followers and visitors).
              </p>

              <h3>Sharing Your Content</h3>
              <p>
                <strong>What We Mean by “Content”.</strong>
                Bebo enhances the ability of Streamers to broadcast live and recorded audio and
                video, and to display text and images. Anything that Streamers transmit, display,
                feature or otherwise make available using the Site, including all Intellectual
                Property Rights (defined below) in such content, is referred to as “Streamer
                Content.” Streamer Content includes streaming live and pre-recorded audio-visual
                works, the contents of chat, bulletin boards, forum postings, wiki contributions,
                voice interactive services, and other content Streamers may create, post, transmit,
                or perform, including sound, images, applications, code, data, or other
                Streamer-owned or third party licensed materials, as well as Streamer’s name,
                identity, likeness, and voice. You retain all of your rights in all of the Streamer
                Content you transmit via our Service, so long as those rights do not infringe any
                third party rights.
              </p>
              <p>
                <strong>Your Responsibility for Your Content:</strong>
              </p>
              <br />
              <ul>
                <li>
                  <strong>
                    We Have Established a Code of Conduct to Preserve the Positive Qualities of our
                    Site.
                  </strong>
                  <p>
                    To preserve the attributes of our Site for the benefit of all participants, we
                    require that you only use our Site in a manner that is consistent with the Bebo{' '}
                    <Link to="/legal/acceptable-use">Acceptable Use Policy</Link>. We reserve the
                    right, but are not obligated, to remove Streamer Content and to disable a
                    Streamer’s account any reason, including due to Streamer Content that we believe
                    violates these Terms or the Bebo{' '}
                    <Link to="/legal/acceptable-use">Acceptable Use Policy</Link>. Please — be a
                    good citizen on Bebo.
                  </p>
                </li>
                <li>
                  <strong>
                    We Have Established Policies to Protect the Rights of Third Parties.
                  </strong>
                  <p>
                    Bebo values and respects the rights of third party creators and content owners,
                    and expects you to do the same. You therefore agree that any Streamer Content
                    that you display using the Site does not and will not violate any law or
                    infringe the rights of any third party, including without limitation any
                    Intellectual Property Rights (defined below), publicity rights or rights of
                    privacy. We may at our discretion remove or disallow Streamer Content from the
                    Service for any reason, including Streamer Content that we believe violates
                    these Terms or the Bebo{' '}
                    <Link to="/legal/acceptable-use">Acceptable Use Policy</Link> or{' '}
                    <Link to="/legal/copyright">Copyright Policy</Link>. Streamers are in the best
                    position to know if the materials they transmit are legally allowed. Please be
                    careful when deciding whether to make Streamer Content available on our Service,
                    including whether you can transmit Streamer Content.
                  </p>
                </li>
              </ul>
              <p>
                <strong>What We Mean By Intellectual Property Rights.</strong> When we refer to
                “Intellectual Property Rights” in these Terms, we mean all patent rights; copyright
                rights; moral rights; rights of publicity; trademark, trade dress and service mark
                rights (and associated goodwill); trade secret rights; and all other intellectual
                property and proprietary rights as may now exist or hereafter come into existence,
                and all applications for any of these rights and registrations, renewals, and
                extensions of any of these rights, in each case under the laws of any state,
                country, territory or other jurisdiction.
              </p>

              <h3>BEBO Content</h3>
              <p>
                <strong>
                  Some Content on BEBO belongs to our Company and We Retain all Rights to it.
                </strong>
                Except for Streamer Content, the Site itself, all content and other subject matter
                included on or within the Site, and all Intellectual Property Rights in or related
                to the Site or any such content or other subject matter (“Bebo Content”) are the
                property of Bebo and its licensors. Except as expressly provided in these Terms, you
                agree not to use, modify, reproduce, distribute, sell, license, or otherwise exploit
                the Bebo Content without our permission.
              </p>

              <p>
                <strong>Your Basic Rights as a BEBO Streamer.</strong> Subject to the terms and
                conditions of these Terms and our{' '}
                <Link to="/legal/acceptable-use">Acceptable Use Policy</Link> and{' '}
                <Link to="/legal/copyright">Copyright Policy</Link>, we grant you a license to
                participate in the Site, including accessing and incorporating Bebo tools and
                functionality offered to Streamers, for your personal or commercial use on Twitch
                and other streaming platforms. Bebo may terminate this license at any time for any
                reason or no reason. Except for the rights and licenses expressly granted, Bebo
                reserves all other rights and no other rights are granted by implication or
                otherwise.
              </p>

              <h3>Copyright Policy</h3>
              <p>
                Bebo has adopted and implemented the Bebo{' '}
                <Link to="/legal/copyright">Copyright Policy</Link> in accordance with the Digital
                Millennium Copyright Act. For more information, please read our{' '}
                <Link to="/legal/copyright">Copyright Policy</Link>.
              </p>

              <h3>Using BEBO – Age Restrictions</h3>
              <p>
                <strong>Who can use BEBO.</strong> You may use the Service only in compliance with
                these Terms and all applicable local, state, national, and international laws, rules
                and regulations.{' '}
                <em>
                  Any use or access to the Site by anyone under the age of 13 is strictly
                  prohibited.
                </em>
              </p>
              <p>
                <strong>We Can Change the Service Anytime Without Notice.</strong> Here at Bebo,
                we’re always finding ways to provide our Streamers with new and innovative features
                and services. Therefore, we may, without prior notice, change the Service; add
                features, stop providing the Service or features of the Site, to you or to Streamers
                generally; or create usage limits for the Site.
              </p>

              <h3>Privacy and Security</h3>
              <p>
                <strong>How we Handle Your Personally Identifiable Information.</strong> We care
                about the privacy and security of our Streamers. You understand that by using the
                Site you consent to the collection, use and disclosure of your personally
                identifiable information and aggregate data as set forth in our{' '}
                <Link to="/legal/privacy">Privacy Policy</Link>, and to have your Personally
                Identifiable Information collected, used, transferred to and processed in the United
                States. While we work to protect the security of your information, Bebo cannot
                guarantee that unauthorized third parties will not be able to defeat our security
                measures. You acknowledge that you provide your information at your own risk.
                Followers who purchase or earn virtual currency from Bebo should also review the{' '}
                <Link to="/legal/privacy">Privacy Policy</Link> to see how their personal
                information is collected, stored and used.
              </p>

              <h3>Site</h3>
              <p>
                <strong>There are Restrictions on Your use of Our Site and App.</strong> As a
                Streamer, Bebo grants to you a non-exclusive, non-transferable, revocable license to
                use a compiled code copy of the Site for one Bebo account. You may not: (i) modify,
                disassemble, decompile or reverse engineer the Site make any copies of the Site;
                (ii) remove, circumvent, disable, damage or otherwise interfere with
                security-related features of the Site, features that prevent or restrict use or
                copying of any content accessible through the Site, or features that enforce
                limitations on use of the Site; or (iii) delete the copyright and other proprietary
                rights notices on the Site. You acknowledge that Bebo may from time to time issue
                upgraded versions of the Site, and may automatically electronically upgrade the
                version of the Site that you are using on your device. You consent to such automatic
                upgrading on your device, and agree that the terms and conditions of these Terms
                will apply to all such upgrades. Any third-party code that may be incorporated in
                the Site is covered by the applicable open source or third-party end Streamer
                license agreement, if any, authorizing use of such code. The foregoing license grant
                is not a sale of the Site or any copy thereof, and Bebo or its third party licensors
                or suppliers retain all right, title, and interest in and to the Site (and any copy
                of the Site). You agree to comply with all United States and foreign laws related to
                use of the Site. You may not, except to the extent that such restriction is
                expressly prohibited by law; (i) rent, lease, loan, resell, sublicense, distribute
                or otherwise transfer the Site to any third party or use the Site to provide time
                sharing or similar services for any third party; (ii) make any copies of the Site;
                (iii) remove, circumvent, disable, damage or otherwise interfere with
                security-related features of the Site, features that prevent or restrict use or
                copying of any content accessible through the Site, or features that enforce
                limitations on use of the Site ; or (iv) delete the copyright and other proprietary
                rights notices on the Site or embedded in its features. You acknowledge that Bebo
                may from time to time issue upgraded versions of the Site, and may automatically
                electronically upgrade the version of the Site that you are using on your device.
                You consent to such automatic upgrading on your device, and agree that the terms and
                conditions of these Terms will apply to all such upgrades. Any third-party code that
                may be incorporated in the Site is covered by the applicable open source or
                third-party end Streamer license agreement, if any, authorizing use of such code.
                The foregoing license grant is not a sale of the Site or any copy thereof, and Bebo
                or its third party licensors or suppliers retain all right, title, and interest in
                and to the Site (and any copy of the Site). You agree to comply with all United
                States and foreign laws related to use of the Site and the Service. Standard carrier
                data charges may apply to your use of the Site.
              </p>
              <h3>Indemnity</h3>
              <p>
                <strong>
                  If You Violate our Policies or Infringe on the Rights of Others, You Will be
                  Responsible for All of Our Resulting Losses and Legal Fees.
                </strong>
                You agree to indemnify and hold harmless Bebo’s owners and its shareholders,
                officers, directors, employees and agents, from and against any claims, suits,
                proceedings, disputes, demands, liabilities, damages, losses, costs and expenses,
                including, without limitation, reasonable legal and accounting fees (including costs
                of defense of claims, suits or proceedings brought by third parties), arising out of
                or in any way related to (i) your access to or use of the Site, (ii) your Streamer
                Content, or (iii) your breach of any of these Terms.
              </p>

              <h3>Disclaimers</h3>
              <p>
                <strong>The Only Promise we Make is that We Will Add Significant Value.</strong> THE
                SITE, INCLUDING WITHOUT LIMITATION ALL CONTENT AND OTHER SUBJECT MATTER INCLUDED
                WITHIN THE SITE, ARE PROVIDED ON AN "AS IS" AND “AS AVAILABLE” BASIS, WITHOUT
                WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED. WITHOUT LIMITING THE FOREGOING,
                BEBO SPECIFICALLY DISCLAIMS ANY AND ALL WARRANTIES AND CONDITIONS OF
                MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT AND
                NON-INFRINGEMENT, AND ANY WARRANTIES ARISING OUT OF COURSE OF DEALING OR USAGE OF
                TRADE.
              </p>
              <p>
                Bebo takes no responsibility and assumes no liability for any Streamer Content that
                you or your Followers or any third party distributes on the Site. You are solely
                responsible for your Streamer Content and the consequences of distributing it, and
                you agree that we are only acting as a passive conduit for your and other Streamers’
                online distribution of your and their Streamer Content. You understand and agree
                that you may be exposed to Streamer Content that is offensive, intrusive,
                objectionable, inappropriate for children, or otherwise unsuited to your purpose.
              </p>

              <h3>Limitation of Liability</h3>
              <p>
                <strong>
                  The Service is controlled and operated from its facilities in the United States.
                </strong>{' '}
                Bebo makes no representations that the Service is appropriate or available for use
                in other locations. Those who access or use the Service from other jurisdictions do
                so at their own volition and are entirely responsible for compliance with all
                applicable national, state, local or other laws, statutes, directives, rules,
                regulations, and all interpretations or orders of any government, administrative or
                regulatory authority or court, including but not limited to those related to export
                and import of software, technical information or services. You may not use the
                Service if you are a resident of a country embargoed by the United States, or are a
                foreign person or entity blocked or denied by the United States government. Unless
                otherwise explicitly stated, all materials found on the Service are solely directed
                to individuals, companies, or other entities located in the United States.
              </p>

              <h3>Arbitration and Governing Law</h3>
              <p>
                <strong>You Agree to Arbitrate Our Disputes in Northern California.</strong> For any
                dispute you have with Bebo, you agree to first contact us at{' '}
                <a href="mailto:support@bebo.com">support@bebo.com</a> and attempt to resolve the
                dispute with us informally. In the unlikely event that Bebo has not been able to
                resolve a dispute it has with you after attempting to do so informally, we each
                agree to resolve any claim, dispute, or controversy (excluding claims for injunctive
                or other equitable relief) arising out of or in connection with or relating to these
                Terms, or the breach or alleged breach thereof (collectively, “Claims”), by binding
                arbitration by JAMS commenced and conducted in San Francisco, California. Each party
                will be responsible for paying any JAMS filing, administrative and arbitrator fees
                in accordance with JAMS rules. The award rendered by the arbitrator shall include
                costs of arbitration, reasonable attorneys’ fees and reasonable costs for expert and
                other witnesses, and any judgment on the award rendered by the arbitrator may be
                entered in any court of competent jurisdiction. Nothing in this Section shall
                prevent either party from seeking injunctive or other equitable relief from the
                courts for matters related to data security, intellectual property or unauthorized
                access to the Service. ALL CLAIMS MUST BE BROUGHT IN THE PARTIES’ INDIVIDUAL
                CAPACITY, AND NOT AS A PLAINTIFF OR CLASS MEMBER IN ANY PURPORTED CLASS OR
                REPRESENTATIVE PROCEEDING, AND, UNLESS WE AGREE OTHERWISE, THE ARBITRATOR MAY NOT
                CONSOLIDATE MORE THAN ONE PERSON’S CLAIMS. YOU AGREE THAT, BY ENTERING INTO THESE
                TERMS, YOU AND BEBO ARE EACH WAIVING THE RIGHT TO A TRIAL BY JURY OR TO PARTICIPATE
                IN A CLASS ACTION.
              </p>
              <p>
                <strong>Governing Law.</strong> You agree that: (i) the Site shall be deemed solely
                based in California; and (ii) the Site shall be deemed a passive one that does not
                give rise to personal jurisdiction over Bebo, either specific or general, in
                jurisdictions other than California. These Terms shall be governed by the internal
                substantive laws of the State of California, without respect to its conflict of laws
                principles. The application of the United Nations Convention on Contracts for the
                International Sale of Goods is expressly excluded. We each agree to submit to the
                personal jurisdiction of a state court located in San Francisco County, California
                or the United States District Court for the Northern District of California, for any
                actions for which either party retains the right to seek injunctive or other
                equitable relief, as further described in the Arbitration provision above.
              </p>

              <h3>General Terms</h3>
              <p>
                <strong>Notification Procedures and changes to these Terms.</strong> Bebo may
                provide notifications, whether such notifications are required by law or are for
                marketing or other business related purposes, to you via email notice, “push” mobile
                notification, written or hard copy notice, or through posting of such notice on our
                website, as determined by Bebo in our sole discretion. Bebo reserves the right to
                determine the form and means of providing notifications to you, provided that you
                may opt out of certain means of notification as described in these Terms and our{' '}
                <Link to="/legal/privacy">Privacy Policy</Link>. Bebo may, in its sole discretion,
                modify or update these Terms from time to time, and so you should review this page
                periodically. Your continued use of the Service after any such change constitutes
                your acceptance of the new Terms.
              </p>
              <p>
                <strong>Implied Agreement to Terms of Service.</strong> If you do not agree to any
                of these Terms or to any future Terms of Service, do not use or access (or continue
                to access) the Site. Bebo is not responsible for any automatic filtering you or your
                network provider may apply to email notifications we send to the email address you
                provide us.
              </p>
              <p>
                <strong>Assignment.</strong> These Terms, and any rights and licenses granted
                hereunder, may not be transferred or assigned by you, but may be assigned by Bebo
                without restriction. Any attempted transfer or assignment in violation hereof shall
                be null and void.
              </p>
              <p>
                <strong>Entire Agreement/Severability.</strong> These Terms, the{' '}
                <Link to="/legal/privacy">Privacy Policy</Link>, the{' '}
                <Link to="/legal/acceptable-use">Acceptable Use Policy</Link> and the{' '}
                <Link to="/legal/copyright">Copyright Policy</Link>, together with any amendments
                and any additional agreements you may enter into with Bebo in connection with the
                Site, shall constitute the entire agreement between you and Bebo concerning the
                Site. If any provision of these Terms is deemed invalid by a court of competent
                jurisdiction, the invalidity of such provision shall not affect the validity of the
                remaining provisions of the Terms, which shall remain in full force and effect.
              </p>
              <p>
                <strong>No Waiver.</strong> No waiver of any term of these Terms shall be deemed a
                further or continuing waiver of such term or any other term, and Bebo’s failure to
                assert any right or provision under these Terms shall not constitute a waiver of
                such right or provision.
              </p>
              <p>
                <strong>Contact.</strong> Please contact us at{' '}
                <a href="mailto:support@bebo.com">support@bebo.com</a> with any questions regarding
                these Terms. Our mailing address is 387 Tehama Street, San Francisco, California and
                our telephone number is 415-896-9200.
              </p>
              <p>
                <strong>Headings.</strong> The PARAGRAPH HEADINGS in this policy are only meant to
                help you quickly find paragraphs. They are not legal statements, policy statements
                or contract terms – they are only labels for reference purposes.
              </p>
            </section>
          </article>
        </section>
      </div>
    );
  }
}

Terms.displayName = 'Terms';

// Uncomment properties you need
// Terms.propTypes = {};
// Terms.defaultProps = {};

export default Terms;
