import React, { memo, useEffect, useState } from 'react';
import { Redirect } from '@reach/router';
import { FullSizeLoader } from 'bebo-ui';

import { GET } from 'classes/socket';

const MatchRedirect = memo(({ match_id }) => {
  const [match, setMatch] = useState(null);
  const [matchError, setMatchError] = useState(null);
  console.log('*** match_id', { match_id, match, matchError });

  useEffect(() => {
    GET('/match', { match_id })
      .then(response => {
        const match = response && response.result && response.result[0];
        if (!match) {
          return Promise.reject(new Error('no match in result[0]'));
        }
        setMatch(match);
      })
      .catch(err => {
        console.error('failed to get match', err);
        setMatchError(err);
      });
  }, [match_id]);

  if (matchError) {
    return <Redirect to="/join" noThrow />;
  }
  if (match) {
    return <Redirect to={`/app/league/${match.league_id}/match/${match.match_id}`} noThrow />;
  }
  return <FullSizeLoader />;
});

export default MatchRedirect;
