import React, { memo } from 'react';
import { Redirect } from '@reach/router';

import { parse } from 'querystringify';

const Notification = memo(({ location }) => {
  const queryString = location.search || '';
  const { notification_id, match_id, tournament_id } = parse(queryString);

  if (notification_id) {
    console.info('opened notification:', notification_id);
  }

  if (match_id) {
    return <Redirect noThrow to={`/match/${match_id}`} />;
  }
  if (tournament_id) {
    return <Redirect noThrow to={`/tournament/${tournament_id}`} />;
  }

  return <Redirect noThrow to="/join" />;
});

export default Notification;
