import React, { useMemo } from 'react';

import cx from 'classnames';

import css from './ui.module.scss';

const generateRoundText = (round_cnt, round) => {
  if (round_cnt < 1) {
    return 'Warm Up';
  }
  if (round < 1) {
    return 'Starting...';
  }

  const currentRound = round_cnt - round;

  if (currentRound === 2) {
    return `Quarter Finals`;
  }
  if (currentRound === 1) {
    return `Semi Finals`;
  }
  if (currentRound === 0) {
    return `Finals`;
  }
  return `Round of ${Math.pow(2, currentRound)}`;
};

const OverlayUI = ({ tournament, match, actingTeam }) => {
  const round = parseInt(tournament.round, 10);
  const round_cnt = parseInt(tournament.round_cnt, 10);

  const roundText = useMemo(() => generateRoundText(round_cnt, round), [round_cnt, round]);

  if (!tournament || !match || !actingTeam) {
    return null;
  }

  return (
    <div className={css.container}>
      {tournament.image_url && (
        <img className={css.tournamentLogo} src={tournament.image_url} alt="" />
      )}
      <div className={css.overlay}>
        <div className={css.header}>
          <h1>{tournament.name}</h1>
          <h3>{roundText}</h3>
        </div>
        <div className={css.body}>
          <div className={css.users}>
            {match.sets.map((set, i) => {
              const user = set.team.users[0];
              return (
                <React.Fragment key={set.set_id}>
                  <div
                    className={cx(
                      css.user,
                      actingTeam.team_id === set.team.team_id ? css.highlight : ''
                    )}
                  >
                    <div className={i === 0 ? css.gamesLeft : css.gamesRight}>
                      <div className={cx(css.game, set.round === 1 ? css.activeGame : '')}>
                        <label>1</label>
                        <p>{set.scores.length >= 1 ? set.scores[0] : '?'}</p>
                      </div>
                      <div className={cx(css.game, set.round === 2 ? css.activeGame : '')}>
                        <label>2</label>
                        <p>{set.scores.length >= 2 ? set.scores[1] : '?'}</p>
                      </div>
                    </div>
                    <img src={user.image_url} alt="" />
                    <h4>{user.username}</h4>
                  </div>
                  {i === 0 ? <h2 className={css.vs}>VS</h2> : null}
                </React.Fragment>
              );
            })}
          </div>
        </div>
      </div>
    </div>
  );
};

export default OverlayUI;
