import React, { memo, useMemo } from 'react';

// import Config from 'scripts/config.js';
import { isLoggedIn$ } from 'controllers/user';

import { Link, Redirect } from '@reach/router';

import './Signup.scss';
import * as css from './signup.module.scss';

import LoginFlow from 'components/login';

import useObservable from 'hooks/useObservable';
import useTrack from 'hooks/useTrack';
import useLoadTimes from 'hooks/useLoadTimes';

const Signup = memo(({ isSignup, ...rest }) => {
  useLoadTimes();
  const signupTrack = useTrack('signup_funnel', isSignup ? 'signup' : 'login');
  const starRoute = useMemo(
    () =>
      rest['*']
        .split('/')
        .slice(1, rest['*'].length)
        .map(e => `/${e}`)
        .join(''),
    [rest]
  );

  const isLoggedIn = useObservable(isLoggedIn$);

  if (isLoggedIn === true) {
    return <Redirect noThrow to={starRoute ? starRoute : '/join'} />;
  } else if (isLoggedIn !== false) {
    return null;
  }

  return (
    <div className="app-root">
      <div className={css.background} />
      <div className="signin">
        <div className="signin__main">
          <div className="signin__main__header">
            <Link
              to="/"
              onClick={() => {
                signupTrack('navigate', { to: 'home' });
              }}
            >
              <h1>BEBO</h1>
            </Link>
            <h4>A League for Every Gamer</h4>
          </div>
          <LoginFlow allowUserName isSignup={isSignup} track={signupTrack} starRoute={starRoute} />
        </div>
      </div>
    </div>
  );
});

export default Signup;
