import React from 'react';
import { Button } from 'bebo-ui';
import { Redirect, Link } from '@reach/router';

import useActingUser from 'hooks/useActingUser';
import useTrack from 'hooks/useTrack';

import 'routes/signup/Signup.scss';
import * as css from './success.module.scss';

import UserController from 'controllers/user';

const Success = () => {
  const track = useTrack('signup_funnel', 'success');
  const actingUser = useActingUser();

  if (actingUser && actingUser.leagues && actingUser.leagues.length) {
    return <Redirect noThrow to="/welcome" />;
  }
  return (
    <div className="app-root">
      <div className={css.background} />
      <div className="signin">
        <Button
          style={{ position: 'absolute', top: 10, right: 10 }}
          danger
          onClick={() => {
            track('logout');
            UserController.logout();
          }}
        >
          Logout
        </Button>
        <div className="signin__main">
          <div className="signin__main__header">
            <Link to="/">
              <h1>BEBO</h1>
            </Link>
            <h4>A League for Every Gamer</h4>
          </div>

          <div className="signin__main__form">
            <div style={{ width: '100%', height: 0, paddingBottom: '57%', position: 'relative' }}>
              <iframe
                title="giphy"
                src="https://giphy.com/embed/7rj2ZgttvgomY"
                width="100%"
                height="100%"
                style={{ position: 'absolute' }}
                frameBorder="0"
                className="giphy-embed"
                allowFullScreen
              />
            </div>

            <p className={css.successMessage}>Success! You're signed up.</p>

            <p className={css.windowsWall}>Got Windows 10?</p>

            <Button
              fluid
              primary
              link="/i/homepagesolo"
              className={css.playNowButton}
              onClick={() => {
                track('navigate', { to: 'homepagesolo' });
              }}
            >
              Play Now (Win10 only)
            </Button>

            <p>Support for PS4 and Xbox coming soon.</p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Success;
