import React, { memo, useEffect, useState } from 'react';
import { Redirect } from '@reach/router';
import { FullSizeLoader } from 'bebo-ui';

import { GET } from 'classes/socket';

const TournamentRedirect = memo(({ tournament_id }) => {
  const [tournament, setTournament] = useState(null);
  const [tournamentError, setTournamentError] = useState(null);
  console.log('*** tournament_id', { tournament_id, tournament, tournamentError });

  useEffect(() => {
    GET('/tournament', { tournament_id })
      .then(response => {
        const tournament = response && response.result && response.result[0];
        if (!tournament) {
          return Promise.reject(new Error('no tournament in result[0]'));
        }
        setTournament(tournament);
      })
      .catch(err => {
        console.error('failed to get tournament', err);
        setTournamentError(err);
      });
  }, [tournament_id]);

  if (tournamentError) {
    return <Redirect to="/join" noThrow />;
  }
  if (tournament) {
    return <Redirect to={`/app/league/${tournament.league_id}/tournament`} noThrow />;
  }
  return <FullSizeLoader />;
});

export default TournamentRedirect;
