import { sendEvents } from 'classes/log-api';

import { getParameterByName, storage } from './utils';

let queue = [];

let UTM_VALUES = {};
let UTM_VALUES_TX = {};

try {
  UTM_VALUES = {
    utm_source: getParameterByName('utm_source'),
    utm_medium: getParameterByName('utm_medium'),
    utm_content: getParameterByName('utm_content'),
    utm_campaign: getParameterByName('utm_campaign'),
    utm_term: getParameterByName('utm_term')
  };
  Object.keys(UTM_VALUES).forEach(k => {
    if (!UTM_VALUES[k]) {
      delete UTM_VALUES[k];
      return;
    }
    UTM_VALUES_TX[`${k}_tx`] = UTM_VALUES[k];
  });
} catch (e) {
  console.error('failed to get utm params', e);
}

export const getUtmValues = () => UTM_VALUES;

export const setUtmValues = ({
  campaign_content: utm_content,
  campaign_medium: utm_medium,
  campaign_name: utm_campaign,
  campaign_source: utm_source
}) => {
  UTM_VALUES = { utm_content, utm_medium, utm_campaign, utm_source, ...UTM_VALUES };
  Object.keys(UTM_VALUES).forEach(k => {
    if (!UTM_VALUES[k]) {
      delete UTM_VALUES[k];
      return;
    }
    UTM_VALUES_TX[`${k}_tx`] = UTM_VALUES[k];
  });
};

const MAX_EVENTS = 100;

let sendTimeout = 0;

const actuallyDoSend = () => {
  if (queue && queue.length) {
    const events = queue.slice().map(event => {
      event.campaign_nest = UTM_VALUES_TX;
      const invite_code = storage.get('invite-code');
      if (invite_code) {
        event.campaign_nest.invite_code_tx = invite_code;
      }
      if (document && document.referrer) {
        event.campaign_nest.referrer_tx = document.referrer;
      }
      return event;
    });
    // sendEvents(events).catch(err => console.localError('failed to send events', err, events));
  }
  queue = [];
};

const addToQueue = event => {
  queue = queue.concat([event]);
  if (queue.length < MAX_EVENTS && sendTimeout) {
    clearTimeout(sendTimeout);
  }
  sendTimeout = setTimeout(actuallyDoSend, 3000);
};

export const track = (category, action, label = '', data = {}) => {
  const event = {
    category,
    action,
    label,
    data
  };

  addToQueue(event);
};
