//  Theme

module.exports = {
  base: '15px',
  spacing: '1rem',
  breakpoints: {
    xs: '0em' /* 0px */,
    sm: '30em' /* 480px */,
    md: '64em' /* 1024px */,
    lg: '75em' /* 1200px */
  },
  typography: {
    font: "-apple-system, BlinkMacSystemFont, 'Inter UI', 'Open Sans', Arial, sans-serif",
    text: '1rem',
    title: '2rem'
  },
  colors: {
    surfaceOne: '#242229',
    surfaceTwo: '#34313B',
    surfaceThree: '#2C2933',
    primary: '#fdd251',
    primaryLight: '#ffec78',
    primaryDark: ' #fcc51f',
    secondary: '#A168FF',
    secondaryLight: '#8a54f5',
    secondaryDark: '#815ac1',
    white100: 'rgba(255, 255, 255, 1)',
    white38: 'rgba(255, 255, 255, 0.38)',
    white60: 'rgba(255, 255, 255, 0.6)',
    white80: 'rgba(255, 255, 255, 0.80)',
    white87: 'rgba(255, 255, 255, 0.87)',
    black100: 'rgba(0, 0, 0, 1)',
    black38: 'rgba(0, 0, 0, 0.38)',
    black60: 'rgba(0, 0, 0, 0.6)',
    black87: 'rgba(0, 0, 0, 0.87)',
    grey5: '#888888',
    link: '#fdd251',
    linkHover: '#ffec78',
    colorRed: '#ff7269',
    yellow: '#ffc369',
    blue: '#3d94bc',
    colorGreen: '#5fe9b7',
    grey: '#757f87',
    appBg: '#37323F',
    dialogBg: '#29262D',
    cardBg: '#2f2d31',
    scrollRail: '#1b1b1b',
    scrollTrack: '#3f4146',
    overlay: 'rgba(0, 0, 0, 0.9)',
    input: '#3b3b3b',
    divider: 'rgba(255, 255, 255, 0.1)',
    borderSelected: '#fcc51f',
    borderDisabled: '#757f87',
    borderError: '#ff7269',
    twitch: '#6441a5',
    twitter: '#1da1f2',
    discord: '#8289da',
    streamlabs: '#32c3a2',
    mixer: '#0075d5',
    youtube: '#ff0000',
    paypal: '#003087',
    blueTeam: '#506CFF',
    redTeam: '#FF4848'
  }
};
