package main

import (
	"fmt"
	"net/http"
	"os"

	"code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"

	"code.justin.tv/esports-exp/vision/internal/twirp"
	serviceapi "code.justin.tv/esports-exp/vision/pkg/client"
)

func main() {
	svc, err := twirp.NewVisionServer()
	if err != nil {
		fmt.Printf("Failed to create server -- %s \n", err.Error())
		os.Exit(1)
	}

	twirpHandler := serviceapi.NewVisionServer(svc, nil)

	mux := http.NewServeMux()
	mux.Handle(serviceapi.VisionPathPrefix, twirpHandler)

	portStr := os.Getenv("PORT")
	if portStr == "" {
		fmt.Println("No PORT env var present")
		os.Exit(1)
	}

	location := fmt.Sprintf(":%s", portStr)
	err = lambda.ListenAndServe(location, mux)

	if err != nil {
		panic(err)
	}
}
