package storage

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
)

// TokenDao is used to access or persist token data
type TokenDao struct {
	dao
}

// TokenEntry represents an entry in the pricing database
type TokenEntry struct {
	DeviceId string `json:"DeviceId"`

	Token    string `json:"Token"`
	Platform string `json:"Platform"`
	Name     string `json:"Name"`
	AppBuild string `json:"AppBuild"`

	Capabilities       []string `json:"Capabilities" dynamodbav:",stringset,omitemptyelem"`
	OnSiteCapabilities []string `json:"OnSiteCapabilities"  dynamodbav:",stringset,omitemptyelem"`
	Languages          []string `json:"Languages"  dynamodbav:",stringset,omitemptyelem"`

	CreatedDTTM time.Time `json:"CreatedDTTM"`
}

// NewTokenDao constructs a new TokenDao
func NewTokenDao(ddb dynamodbiface.DynamoDBAPI) *TokenDao {
	return &TokenDao{
		dao{
			ddb:          ddb,
			tableNameKey: "TOKEN_TABLE_NAME",
		},
	}
}

func (t *TokenDao) Put(ctx context.Context, entry *TokenEntry) error {
	return t.put(ctx, entry)
}
