job {
  name 'twitch-wall'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'web/wall', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v -proxy'
    saveDeployArtifact 'web/wall', '.manta'
  }
}

job {
  name "twitch-wall-deploy"

  parameters {
    stringParam 'GIT_COMMIT'
    stringParam 'SKADI_ID'
    stringParam 'ENVIRONMENT'
  }

  wrappers {
    credentialsBinding {
      file 'AWS_CONFIG_FILE', 'aws_config'
      file 'AWS_WALL_CONFIG_FILE', 'wall_iam'
      string 'dta_tools_deploy', 'dta_tools_deploy'
    }
  }

  steps {
    downloadDeployArtifact 'web/wall'
    shell """
      export AWS_CONFIG_FILE=\$AWS_WALL_CONFIG_FILE
      aws s3 cp static/ s3://wall.office.justin.tv/  --recursive --grants read=uri=http://acs.amazonaws.com/groups/global/AllUsers
      aws lambda update-function-code --function-name mason --zip-file fileb://mason.zip
    """
  }
}

