import * as React from 'react';

import './style.css';

interface Props {
  hlsURL: string;
  onError: () => void;
}

export class NativePlayer extends React.Component<Props, {}> {
  private videoEl: HTMLVideoElement | null = null;

  public shouldComponentUpdate() {
    return false;
  }

  public render() {
    return (
      <video
        className="native embedded-video"
        src={this.props.hlsURL}
        ref={this.setVideoRef}
        muted
      />
    );
  }

  public componentWillUnmount() {
    if (this.videoEl) {
      this.videoEl.pause();
      this.videoEl.src = '';
      this.videoEl.load();
      this.videoEl.removeEventListener('error', this.onVideoError);
      this.videoEl.removeEventListener('ended', this.onVideoError);
      this.videoEl.removeEventListener('canplay', this.onVideoCanPlay);
    }
  }

  private setVideoRef = (video: HTMLVideoElement | null) => {
    if (video) {
      this.videoEl = video;

      this.videoEl.addEventListener('error', this.onVideoError);
      this.videoEl.addEventListener('canplay', this.onVideoCanPlay);
      this.videoEl.addEventListener('ended', this.onVideoError);
    }
  };

  private onVideoError = () => {
    this.props.onError();
  };

  private onVideoCanPlay = () => {
    if (this.videoEl) {
      this.videoEl.play();
    }
  };
}
