import * as React from 'react';

import { HLSPlayer } from 'wall/components/hls-player';
import { ChatPlayer } from 'wall/components/chat-player';
import { NativePlayer } from 'wall/components/native-player';
import { shouldUseNativeVideo } from 'wall/lib/support';

import './style.css';

interface Props {
  name: string;
  viewers: number;
  channel: string;
  game: string;
  hlsURL: string;
  replaceChannel: (channel: string) => void;
}

export const VideoFrame: React.StatelessComponent<Props> = props => {
  let player = null;
  let date = new Date();
  if (date.getDate() === 1 && date.getMonth() === 3) {
    // April fools
    player = <ChatPlayer channelLogin={props.channel} />;
  } else {
    if (shouldUseNativeVideo) {
      player = (
        <NativePlayer
          hlsURL={props.hlsURL}
          onError={() => {
            props.replaceChannel(props.channel);
          }}
        />
      );
    } else {
      player = (
        <HLSPlayer
          hlsURL={props.hlsURL}
          onError={() => {
            props.replaceChannel(props.channel);
          }}
        />
      );
    }
  }

  return (
    <div className="video-frame">
      {player}
      <div className="info-panel">
        <div className="playing">
          {props.name} playing {props.game}
        </div>
        <div className="views">
          {props.viewers.toLocaleString('en-us', { useGrouping: true })}
        </div>
      </div>
    </div>
  );
};
