import { API_HOSTNAME } from 'config';

interface FeaturedResponse {
  id: number;
  channel_name: string;
  display_name: string;
  viewers: number;
  game: string;
  mature: boolean;
}

export interface Stream {
  id: string;
  channel: string;
  displayName: string;
  viewers: number;
  game: string;
  mature: boolean;
}

export async function getFeaturedChannels(): Promise<Array<Stream>> {
  let response = await fetch(
    `${API_HOSTNAME}/streams${window.location.search}`,
  );

  let parsedResponse: Array<FeaturedResponse> = await response.json();

  return parsedResponse.map(item => ({
    id: item.id.toString(),
    channel: item.channel_name,
    displayName: item.display_name,
    viewers: item.viewers,
    game: item.game,
    mature: item.mature,
  }));
}

export async function getHLSURLForChannel(channel: string): Promise<string> {
  return `${API_HOSTNAME}/watch/${channel}.m3u8`;
}
