import io
from datetime import datetime
from math import isnan

import pandas as pd
import dateutil.parser
from snappy import stream_decompress
from google.protobuf.json_format import MessageToDict

from sample_pb2 import TCPConnections

def parse_record_into_sample(data):
    data = io.BytesIO(data)
    outfile = io.BytesIO()
    stream_decompress(data, outfile)
    data.close()

    connections = TCPConnections()
    connections.ParseFromString(outfile.getvalue())
    outfile.close()

    return connections

def buffer_to_sql(data):
    sample = parse_record_into_sample(data)

    connections = pd.DataFrame(map(MessageToDict, sample.connections))

    connections['timestamp'] = connections['timestamp'].astype('datetime64[ns]')

    connections['bytes_out_rate'] = connections.throughput.map(lambda t: t.get('bytesOutRate')).astype(float)
    connections['window'] = connections.throughput.map(lambda t: t.get('window')).astype(float)
    connections['bandwidth'] = connections['bytes_out_rate'] * 8.0
    connections['segs_out_rate'] = connections.throughput.map(lambda t: t.get('segsOutRate')).astype(float)
    connections['segs_out_loss_rate'] = connections.throughput.map(lambda t: t.get('segsOutLossRate')).astype(float)
    connections['segs_out_loss_ratio'] = connections.throughput.map(lambda t: t.get('segsOutLossRatio')).astype(float)
    connections['packet_loss'] = connections['segs_out_loss_ratio'] * 100.0

    connections['video_session_id'] = connections.sessionInfo.map(lambda e: type(e) == dict and e.get('videoSessionId')).astype(float)
    connections['device_id'] = connections.sessionInfo.map(lambda e: type(e) == dict and e.get('deviceId')).astype(str)
    connections['rtt'] = connections.tcpInfo.map(lambda e: type(e) == dict and e.get('rtt')).astype(float)
    connections['rtt_var'] = connections.tcpInfo.map(lambda e: type(e) == dict and e.get('rttVar')).astype(float)
    connections['delivery_rate_app_limited'] = connections.tcpInfo.map(lambda e: type(e) == dict and e.get('rtt_var')).astype(bool)

    connections = connections.rename(columns={"nodeName":"node_name", "congestionControl": "congestion_control"})

    for k in ['tcpInfo', 'throughput', 'srcIp', 'srcPort', 'dstIp', 'dstPort', 'sessionInfo', 'hostClass']:
        try:
            del connections[k]
        except Exception:
            pass

    return connections

#    df = pd.DataFrame(sample.connections)
#    return df
#    df["timestamp"] = 


#    for connection in sample.connections:
#        try:
#            connections.append(convert_to_sql(connection))
#        except ValueError as e:
#            sys.stderr.write("Failed to convert %s to sql -- %s \n" % (connection, e))
#
#    return connections

#    return pd.DataFrame(connections)
