import os
import boto3
import logging

from botocore.exceptions import ClientError

for k in os.environ:
    if k[:3] == "AWS":
        del os.environ[k]

s3 = boto3.client("s3")
BUCKET="darkseer-ward-s3"

def upload_file(file_name, object_name):
    """Upload a file to an S3 bucket

    :param file_name: File to upload
    :param object_name: Path to upload to
    :return: True if file was uploaded, else False
    """

    # Upload the file
    try:
        response = s3.upload_file(file_name, BUCKET, object_name)
    except ClientError as e:
        logging.error(e)
        return False

    return True
