#!/bin/bash
set -e

JOB_NAME=warg
ENV=local
SSH_PRIVATE_KEY=${SSH_PRIVATE_KEY:-~/.ssh/id_rsa}
CONTAINER_HOSTNAME=$(hostname).${JOB_NAME}
DOCKER_UID=$(id -u docker)

cp ${SSH_PRIVATE_KEY} ./ssh_private_key

docker rm -f ${JOB_NAME} || true

docker build -t ${JOB_NAME}:${ENV} --rm --build-arg DOCKER_UID=$DOCKER_UID --build-arg BEBO_ENV=${ENV} .

rm ./ssh_private_key

docker run -it --rm \
    --name ${JOB_NAME} \
    --network host \
    -v "/var/run/docker.sock:/var/run/docker.sock" \
    -v "/data/dispatcher:/data/dispatcher" \
    --hostname ${CONTAINER_HOSTNAME} \
    --user $DOCKER_UID \
    ${JOB_NAME}:${ENV}
