import json

import etcd

from logger import log

class EtcdApi(object):
    def __init__(self):
        self.etcd_host = 'localhost'
        self.etcd_port = 2379
        self.client = etcd.Client(host=self.etcd_host, port=self.etcd_port)

    def get(self, key):
        try:
            return self.client.read(key, timeout=1).value
        except etcd.EtcdKeyNotFound:
            return None

    def set(self, key, value, ttl=None):
        log.debug('EtcdApi:set key={}, value={}'.format(key, value))
        self.client.write(key, value, ttl=ttl, timeout=1)

    def set_box_health(self, box_name, value, ttl=None):
        key = "health/{}".format(box_name)
        return self.set(key, value, ttl)

    def get_service(self, service_name):
        return self.get_json('service/{}'.format(service_name))

    def get_cluster(self, cluster_name):
        return self.get_json('cluster/{}'.format(cluster_name))

    def get_json(self, key):
        resp = self.get(key)
        try:
            return json.loads(resp)
        except Exception:
            return {}
