import socket
from config import cfg

from bebo import dispatcher, utils

def get_private_node_hostname():
    instance_name = socket.getfqdn().split('.')[0]

    return "{}.{}".format(instance_name, cfg.internal_domain)

def write_docker_event(data=None):
    if not data:
        return
    queue_name = 'docker-stats_es'
    data = utils.convert_to_es(data)
    #  log.debug('Writing dispatcher obj: {}'.format(data))
    dispatcher.write(queue_name, data)

def calc_cpu_percentage(stats):
    cpu_count = stats["cpu_stats"]["online_cpus"]
    cpu_percent = 0.0
    cpu_delta = float(stats["cpu_stats"]["cpu_usage"]["total_usage"]) - \
            float(stats["precpu_stats"]["cpu_usage"]["total_usage"])
    system_delta = float(stats["cpu_stats"]["system_cpu_usage"]) - \
            float(stats["precpu_stats"]["system_cpu_usage"])

    if cpu_count == 0:
        cpu_count = len(stats["cpu_stats"]["online_cpus"]["percpu_usage"])

    if system_delta > 0.0 and cpu_delta > 0.0:
        cpu_percent = (cpu_delta / system_delta) * 100.0 * cpu_count

    return cpu_percent
