import YellerApi from '../apis/yeller_api';
import { notification } from 'antd';

export const RESET_DATASET = 'RESET_DATASET';
export const resetDataset = () => ({ type: RESET_DATASET });

export const LOAD_DATASET = 'LOAD_DATASET';
export const loadDataset = (database, collection, excludeImages = null) => {
  const query = {
    limit: 100,
    qs: {
      label: 'null',
      created_at: { $gt: 1541030400 }
    }
  };

  if (excludeImages) {
    query.qs['_id'] = {
      $nin: excludeImages.map(x => x.id)
    };
  }

  return dispatch => {
    dispatch(resetDataset());
    Promise.all([
      YellerApi.countImages(database, collection, query),
      YellerApi.getImages(database, collection, query)
    ])
      .then(([count, data]) => {
        dispatch({ type: LOAD_DATASET, database, collection, data, count });
      })
      .catch(err => {
        console.error(err);
        notification.error({
          message: 'Error loading dataset',
          description: err.message
        });
        dispatch({ type: LOAD_DATASET, database, collection, data: [], count: 0 });
      });
  };
};

export const UPDATE_LABEL = 'UPDATE_LABEL';
export const updateLabel = (index, label) => ({ type: UPDATE_LABEL, index, label });

export const UPDATE_EXTRA = 'UPDATE_EXTRA';
export const updateExtra = (index, extra) => ({ type: UPDATE_EXTRA, index, extra });

export const UPDATE_DEFAULT_CLASS = 'UPDATE_DEFAULT_CLASS';
export const updateDefaultClass = defaultClass => ({ type: UPDATE_DEFAULT_CLASS, defaultClass });

export const UPDATE_SHOW_EXTRA = 'UPDATE_SHOW_EXTRA';
export const updateShowExtra = showExtra => ({ type: UPDATE_SHOW_EXTRA, showExtra });
