import config from '../config.js';
import rp from 'request-promise';

const TEST_EXAMPLES = [
  {
    label: 'normal',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: "normal gameplay that isn't the other labels"
  },
  {
    label: 'lobby',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when the player is in the lobby'
  },
  {
    label: 'kill',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when the player elimates somebody'
  },
  {
    label: 'knock',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when the player knocks somebody'
  },
  {
    label: 'storm',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when the player is in the storm'
  },
  {
    label: 'spectating',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when the player is in the storm'
  },
  {
    label: 'death',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when a player dies'
  },
  {
    label: 'victory',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when a player dies'
  },
  {
    label: 'skip',
    url:
      'https://images.pexels.com/photos/104827/cat-pet-animal-domestic-104827.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=1080&w=1920',
    description: 'when the player is in the storm'
  }
];

class BaseApi {
  static get(db, collection, queryObj) {
    const options = {
      url: `${BaseApi.getApiUrl()}/${db}/${collection}`,
      qs: queryObj,
      json: true
    };

    return rp(options);
  }

  static post(db, collection, obj) {
    const options = {
      method: 'POST',
      url: `${BaseApi.getApiUrl()}/${db}/${collection}`,
      body: obj,
      json: true
    };

    return rp(options);
  }

  static put(db, collection, mergeObj) {
    const options = {
      method: 'PUT',
      url: `${BaseApi.getApiUrl()}/${db}/${collection}`,
      body: mergeObj,
      json: true
    };

    return rp(options);
  }

  static delete(db, collection, id) {
    const options = {
      method: 'DELETE',
      url: `${BaseApi.getApiUrl()}/${db}/${collection}`,
      qs: { id },
      json: true
    };

    return rp(options);
  }

  static query(db, collection, queryObj) {
    const options = {
      method: 'POST',
      url: `${BaseApi.getApiUrl()}/query/${db}/${collection}`,
      body: queryObj,
      json: true
    };

    return rp(options);
  }

  static getApiUrl() {
    return config.YELLER_URL;
  }
}

class YellerApi {
  static getLabels() {
    return Promise.resolve(TEST_EXAMPLES.map(ex => ex.label));
  }

  static getImageExample(labels) {
    return Promise.resolve(TEST_EXAMPLES);
  }

  static getImages(db, collection, query) {
    return BaseApi.query(db, collection, query).then(jsonBody => {
      return jsonBody.result;
    });
  }

  static countImages(db, collection, query) {
    const options = {
      method: 'POST',
      url: `${BaseApi.getApiUrl()}/count/${db}/${collection}`,
      body: query,
      json: true
    };

    return rp(options);
  }

  static updateImageLabels(db, collection, images) {
    return Promise.all([
      images.map(({ id, label, old_label, extra, bucket_name, key }) => {
        const mergeObj = { id, label, old_label, extra, bucket_name, key };
        return BaseApi.put(db, collection, mergeObj);
      })
    ]);
  }

  static getUploadFileUrl() {
    return `${BaseApi.getApiUrl()}/upload_file`;
  }

  static uploadTwitchClip(detector, twitchClipUrl) {
    const options = {
      method: 'POST',
      url: `${BaseApi.getApiUrl()}/upload_url`,
      body: {
        detector,
        twitchClipUrl
      },
      json: true
    };
    return rp(options);
  }
}

export default YellerApi;
