import React, { Component } from 'react';
import { Link, Switch, Route } from 'react-router-dom';
import { Layout, Row, Col } from 'antd';

import Home from './Home';
import Dataset from './Dataset';
import DatasetSelector from './DatasetSelector';

import '../styles/App.css';

class App extends Component {
  render() {
    return (
      <Layout className="layout" style={{ minHeight: '100vh' }}>
        <Layout.Header>
          <Row type="flex" align="middle">
            <Col span={4}>
              <Link to='/'>
                <div className="logo">YELLER</div>
              </Link>
            </Col>
            <Col>
              <Route path="/:database?/:collection?" component={DatasetSelector}/>
            </Col>
          </Row>
        </Layout.Header>
        <Layout.Content className="app-content">
          <Switch>
            <Route exact path="/" component={Home} />
            <Route exact path="/:database/:collection" component={Dataset} />
          </Switch>
        </Layout.Content>
        <Layout.Footer className="app-footer">Yeller © Bebo</Layout.Footer>
      </Layout>
    );
  }
}

export default App;
