import React, { Component } from 'react';
import { Row, Col, Upload, Icon, notification, Form, Input, Select, Button, AutoComplete } from 'antd';

import YellerApi from '../apis/yeller_api';
import { UPLOAD_DETECTORS } from '../constants';
import '../styles/DatasetUpload.css';

class DataUpload extends Component {
  state = {
    detector: 'Fortnite_kill_no',
    twitchClipUrl: ''
  };

  onFileChange(info) {
    const status = info.file.status;
    if (status === 'done') {
      notification.success({
        message: `${info.file.name} uploaded for ${this.state.detector}`,
        description: `Data will show up in /upload/${this.state.detector} soon`
      });
    } else if (status === 'error') {
      notification.error({ message: `${info.file.name} upload failed.` });
    }
  }

  handleTwitchSubmit(e) {
    e.preventDefault();
    const clipName = this.state.twitchClipUrl.split('/').pop();

    YellerApi.uploadTwitchClip(this.state.detector, this.state.twitchClipUrl)
      .then(() => {
        notification.success({
          message: `${clipName} submitted for ${
            this.state.detector
            }`,
          description: `Data will show up in /upload/${this.state.detector} soon`
        });
        this.setState({ twitchClipUrl: '' });
      })
      .catch(err => {
        notification.error({
          message: `Error submitting ${clipName}`,
          description: err.message
        });
        this.setState({ twitchClipUrl: '' });
      });
  }

  renderSubmitTwitchClip() {
    return (
      <React.Fragment>
        <Row type="flex" justify="center">
          <Col>
            <h2> Twitch, Youtube, Mp4 Link </h2>
          </Col>
        </Row>
        <Row type="flex" justify="center">
          <Col>
            <Form layout="inline" onSubmit={e => this.handleTwitchSubmit(e)}>
              <Form.Item label="URL">
                <Input
                  className="dataset-upload-url-input"
                  value={this.state.twitchClipUrl}
                  onChange={e => this.setState({ twitchClipUrl: e.target.value })}
                  placeholder="https://clips.twitch.tv/PentaKill"
                />
              </Form.Item>
              <Form.Item>
                <Button type="primary" htmlType="submit" disabled={!this.state.twitchClipUrl}>
                  Submit
                </Button>
              </Form.Item>
            </Form>
          </Col>
        </Row>
      </React.Fragment>
    );
  }

  renderMediaUpload() {
    return (
      <React.Fragment>
        <Row type="flex" justify="center">
          <Col>
            <h2> Direct Upload </h2>
          </Col>
        </Row>
        <Row type="flex" justify="center">
          <Upload.Dragger
            className="dataset-upload-upload"
            name="file"
            multiple={true}
            data={{ detector: this.state.detector }}
            action={YellerApi.getUploadFileUrl()}
            onChange={info => this.onFileChange(info)}
            showUploadList={{ showRemoveIcon: false }}
            accept=".mp4,.jpg,.jpeg,.png"
          >
            <p className="ant-upload-drag-icon">
              <Icon type="inbox" />
            </p>
            <p className="ant-upload-text">Click or drag image/video to here</p>
            <p className="ant-upload-hint">Supported types: *.mp4, *.jpg, *.jpeg, *.png</p>
          </Upload.Dragger>
        </Row>
      </React.Fragment>
    );
  }

  render() {
    return (
      <React.Fragment>
        <Row type="flex" justify="center">
          <Col>
            <h2> Yeller Media Upload </h2>
          </Col>
        </Row>
        <Row type="flex" justify="center">
          <Form layout="inline">
            <Form.Item label="Upload To">
              <AutoComplete
                dataSource={UPLOAD_DETECTORS}
                defaultValue={UPLOAD_DETECTORS[0]}
                placeholder="Detector"
                style={{ width: 300 }}
                onChange={val => this.setState({ detector: val })}
              />
            </Form.Item>
          </Form>
        </Row>
        <br />
        {this.renderSubmitTwitchClip()}
        <br />
        {this.renderMediaUpload()}
      </React.Fragment>
    );
  }
}

export default DataUpload;
