import React, { Component } from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Radio, Input } from 'antd';

import { updateLabel, updateExtra } from '../actions/dataset';

import '../styles/Image.css';

class Image extends Component {
  static propTypes = {
    data: PropTypes.object.isRequired,
    classes: PropTypes.array.isRequired,
    defaultClass: PropTypes.string.isRequired,
    showExtra: PropTypes.bool.isRequired,

    updateLabel: PropTypes.func.isRequired
  };

  handleImageClick(e) {
    e.preventDefault();

    this.props.updateLabel(this.props.data.index, this.getNextClass());
  }

  handleLabelChange(e) {
    this.props.updateLabel(this.props.data.index, e.target.value);
  }

  handleExtraChange(e) {
    this.props.updateExtra(this.props.data.index, e.target.value);
  }

  getNextClass() {
    for (const className of this.props.classes) {
      if ((this.props.data.label || this.props.defaultClass) !== className) {
        return className;
      }
    }
  }

  render() {
    let imgStyle = {
      backgroundImage: `url(${this.props.data.url})`,
      backgroundSize: 'contain'
    };

    if (this.props.datasetSelector.collection.startsWith('apex_kill')) {
      imgStyle = {
        backgroundImage: `url(${this.props.data.url})`,
        backgroundSize: '960px',
        backgroundPosition: 'right top'
      };
    } else if (this.props.datasetSelector.collection.startsWith('pubg_kill')) {
      imgStyle = {
        backgroundImage: `url(${this.props.data.url})`,
        backgroundSize: '960px',
        backgroundPosition: 'right top'
      };
    } else if (this.props.datasetSelector.collection.startsWith('pubgmobile_kill')) {
      imgStyle = {
        backgroundImage: `url(${this.props.data.url})`,
        backgroundSize: '960px',
        backgroundPosition: 'left top'
      };
    }

    return (
      <div className="image-container">
        <div
          className={classNames('image-img', {
            clicked: this.props.data.label && this.props.data.label !== this.props.defaultClass
          })}
          style={imgStyle}
          onClick={e => this.handleImageClick(e)}
        />
        <div className="image-label-select">
          <span> Label: </span>
          <Radio.Group
            onChange={e => this.handleLabelChange(e)}
            value={this.props.data.label || this.props.defaultClass}
          >
            {this.props.classes.map((className, i) => {
              return (
                <React.Fragment key={i}>
                  <Radio value={className}>{className}</Radio>
                </React.Fragment>
              );
            })}
          </Radio.Group>
        </div>
        {this.props.showExtra && (
          <div className="image-extra">
            <Input
              addonBefore="Extra:"
              value={this.props.data.extra}
              onChange={e => this.handleExtraChange(e)}
            />
          </div>
        )}
      </div>
    );
  }
}

const mapStateToProps = state => ({
  datasetSelector: state.datasetSelector,
  ...state.dataset
});
const mapDispatchToProps = { updateLabel, updateExtra };

export default connect(
  mapStateToProps,
  mapDispatchToProps
)(Image);
