import update from 'immutability-helper';

import {
  LOAD_DATASET,
  UPDATE_LABEL,
  UPDATE_EXTRA,
  UPDATE_DEFAULT_CLASS,
  UPDATE_SHOW_EXTRA,
  RESET_DATASET
} from '../actions/dataset';

import { LABEL_MAP, DEFAULT_LABELS, EXTRA_MAP } from '../constants';

const initialState = {
  loading: true,
  defaultClass: null,
  classes: [],
  images: [],
  datasetSize: 0,
  showExtra: false
};

function getS3Url(bucket, key) {
  return `https://${bucket}.s3.amazonaws.com/${key}`;
}

const datasetReducer = (state = initialState, action) => {
  switch (action.type) {
    case LOAD_DATASET: {
      const splits = action.collection.split('_');
      const classes = LABEL_MAP[`${splits[0]}_${splits[1]}`] || DEFAULT_LABELS;
      const showExtra = EXTRA_MAP[`${splits[0]}_${splits[1]}`] || false;

      let defaultClass = classes[0];
      if (classes.indexOf(splits[splits.length - 1]) !== -1) {
        defaultClass = splits[splits.length - 1];
      }

      const images = action.data.map((data, i) => {
        return {
          ...data,
          index: i,
          url: getS3Url(data.bucket_name, data.key),
          label: data.old_label || null,
          loaded: false,
          clicked: false
        };
      });
      return Object.assign({}, state, {
        classes,
        defaultClass,
        showExtra,
        images,
        datasetSize: action.count.result,
        loading: false
      });
    }
    case RESET_DATASET:
      return Object.assign({}, state, { images: [], loading: true });
    case UPDATE_LABEL: {
      const clicked = action.label === null ? false : true;
      const images = {};
      images[action.index] = {
        label: { $set: action.label },
        clicked: { $set: clicked }
      };
      return update(state, { images });
    }
    case UPDATE_EXTRA: {
      const images = {};
      images[action.index] = {
        extra: { $set: action.extra }
      };
      return update(state, { images });
    }
    case UPDATE_DEFAULT_CLASS:
      return Object.assign({}, state, { defaultClass: action.defaultClass });
    case UPDATE_SHOW_EXTRA:
      return Object.assign({}, state, { showExtra: action.showExtra });
    default:
      return state;
  }
};

export default datasetReducer;
