import moment from 'moment';

import { UPDATE_DATASET_SELECTION } from '../actions/datasetSelector';

const initialState = {
  database: 'pre_classify',
  collection: 'Fortnite_kill_yes'
};

const datasetSelectorReducer = (state = initialState, action) => {
  switch (action.type) {
    case UPDATE_DATASET_SELECTION:
      return Object.assign({}, state, {
        database: action.database || state.database,
        collection: action.collection || state.collection
      });
    default:
      return state;
  }
};

export default datasetSelectorReducer;
