#!/bin/bash
set -e
set -x

SSH_PRIVATE_KEY=${SSH_PRIVATE_KEY:-~/.ssh/id_rsa}
JOB_NAME=yeller
BEBO_ENV=${BEBO_ENV:-local}

sudo docker rm -f ${JOB_NAME} || true

cp $SSH_PRIVATE_KEY ./ssh_private_key
sudo docker build -t ${JOB_NAME}:local --rm --build-arg BEBO_ENV=${BEBO_ENV} .
sudo docker run --rm --network="host" --name ${JOB_NAME} -e "BEBO_ENV=${BEBO_ENV}" -v /etc/nginx/ssl:/etc/nginx/ssl ${JOB_NAME}:local
