import json
import time

from pymongo import MongoClient
from bson.objectid import ObjectId

from yeller.config import config

IGNORE_KEYS = ['limit', 'offset']


class MongoHeler:
    def __init__(self):
        self.client = MongoClient(config.MONGO_DB, connect=False)

    def get_db(self, db):
        return self.client[db];

    def get_collection(self, db, collection):
        return self.client[db][collection]

    def prepare_for_write(self, obj, set_created=True):
        now = time.time()
        if set_created:
            obj['created_at'] = now
        elif 'created_at' in obj:
            del obj['created_at']

        obj['updated_at'] = now

        if 'id' in obj:
            del obj['id']

    def prepare_query(self, qs):
        query = {}

        for key in qs:
            if key not in IGNORE_KEYS:
                value = qs[key]
                if value == "null":
                    value = None
                elif value == "false":
                    value = False
                elif value == "true":
                    value = True

                if key == '_id' and isinstance(value, dict) and '$nin' in value:
                    value['$nin'] = [ObjectId(x) for x in value['$nin']]

                query[key] = value

        return query

    def serialize_result(self, result):
        for obj in result:
            if '_id' in obj:
                obj['id'] = str(obj['_id'])
                del obj['_id']
        return json.dumps({'result': result})
