import boto3
import json
from config import config

ssm = boto3.client("ssm", region_name="us-west-2")

def add_parameter_to_store(key):
    val = getattr(config, key)
    name = "/%s/%s/%s" % (config.ENV, config.APP_NAME, key)
    stringified = json.dumps(val)
    print("%s: %s" % (name, stringified))

    ssm.put_parameter(
        Name=name,
        Value=stringified,
        Type="SecureString",
        Overwrite=True
    )



keys = [k  for k in dir(config) if not k.startswith("__")]

print(len(keys), "keys")

for key in keys:
    add_parameter_to_store(key)
