from yeller.logger import log
from yeller.config import DevConfig, ProdConfig
from datetime import datetime
import boto3
import tempfile
import tarfile
import requests
import os

s3 = boto3.resource('s3')


def run_cmd(cmd):
    err = os.system(cmd)
    if err:
        raise Exception("Execution failed: {}".format(err))


class DeployModel:
    def on_get(self, req, resp):
        job_id = req.params['job_id']
        env = req.params['env']
        name = job_id.split('_')[0]

        cfg = DevConfig()
        if env == 'bebo-prod':
            cfg = ProdConfig()

        log.info('Deploying {}: {} to {}'.format(name, job_id, env))

        log.info('downloading weight')
        _, weight_file = tempfile.mkstemp('.pt')
        s3.meta.client.download_file(
            cfg.DEPLOY_BUCKET, 'models/{}/weights.pt'.format(job_id), weight_file)

        log.info('uploading model')
        _, tar_file = tempfile.mkstemp('.tar.gz')
        with tarfile.open(tar_file, "w:gz") as tar:
            tar.add(weight_file, arcname="weights.pt")
        upload_key = 'detectors/{}/{}.tar.gz'.format(env, name)
        s3.meta.client.upload_file(tar_file, cfg.DEPLOY_BUCKET, upload_key)
        os.remove(weight_file)
        os.remove(tar_file)

        log.info('fetching bran version')
        services = requests.get('{}/service'.format(cfg.PHARAH_URL),
                                headers={'X-Api-Key': cfg.API_KEY}).json()

        bran_service = next(
            filter(lambda x: x['name'] == 'bran' and x['bebo_env'] == env, services['result']))
        log.debug('service: {}'.format(bran_service))
        tag = bran_service['version']
        new_tag = '-'.join(tag.split('-')[:1]+[datetime.now().strftime("%Y%m%d%H%M%s")])

        log.info('cloing repo')
        git_dir = tempfile.mkdtemp()
        run_cmd('git clone git@github.com:bebo/bran.git {}'.format(git_dir))
        run_cmd('cd {} && git checkout {}'.format(git_dir, tag))

        log.info('deploying bran')
        run_cmd('cd {} && git tag -a {} -m {}'.format(git_dir, new_tag, job_id))
        run_cmd('cd {} && git push --tags'.format(git_dir))
        requests.get("{}/buildWithParameters?token={}&ENV={}&TAG={}&LIVE=true&PROJECT_NAME=bran".format(
            cfg.JENKINS_URL, cfg.JENKINS_TOKEN, env, new_tag))
        run_cmd('rm -rf {}'.format(git_dir))

        log.info('all done')

        resp.media = {
            'ok': True,
            'tag': new_tag,
            'bucket': cfg.DEPLOY_BUCKET,
            'key': upload_key
        }
