import re
from urllib.parse import parse_qs
import json
import boto3

from bson.objectid import ObjectId
import pymongo

from yeller.classes.mongo import MongoHeler
from yeller.logger import log
from bebo import dispatcher
from bebo import utils as bebo_utils

mongo_helper = MongoHeler()

s3 = boto3.resource('s3')


class RelabelResource:
    def on_get(self, req, resp):
        job_id = req.params['job_id']
        collection = req.params['collection']

        objs = {}

        for split in ['training', 'validation', 'test']:
            for out in ['errors']:

                obj = s3.Object(
                    'gamesense', 'models/{}/{}.{}.json'.format(job_id, split, out))
                content = json.loads(obj.get()['Body'].read().decode('utf-8'))
                for o in content:
                    # transform and dedupe
                    objs[(o['bucket'], o['key'])] = {
                        'bucket_name': o['bucket'],
                        'key': o.get('s3_key', o.get('key')),
                        'label': None,
                        'old_label': o['label']
                    }

        log.info('Writing {} items from {} to db'.format(len(objs), job_id))

        new_count = 0
        for o in objs.values():
            mongo_helper.prepare_for_write(o)
            res = mongo_helper.get_collection(
                'relabel', collection).update_one({
                    'bucket_name': o['bucket_name'],
                    'key': o['key']
                }, {'$set': o}, upsert=True)
            new_count += 1 if res.upserted_id else 0

        resp.media = {'ok': True, 'total': len(objs), 'new': new_count}

    def on_post(self, req, resp):
        collection = req.media['collection']
        data = req.media['data']

        new_count = 0
        for o in data:
            mongo_helper.prepare_for_write(o)
            res = mongo_helper.get_collection(
                'relabel', collection).update_one({
                    'bucket_name': o['bucket_name'],
                    'key': o['key']
                }, {'$set': o}, upsert=True)
            new_count += 1 if res.upserted_id else 0

        resp.media = {'ok': True, 'total': len(data), 'new': new_count}
