import traceback
import falcon
from falcon_cors import CORS
from falcon_multipart.middleware import MultipartMiddleware
import sentry_sdk
from bebo.utils import init_sentry

from yeller.config import config
from yeller.logger import log
from yeller.resources.db import DbResource, DbQuery, DbCount
from yeller.resources.upload import UploadFile, UploadURL
from yeller.resources.deploy_model import DeployModel
from yeller.resources.relabel import RelabelResource

init_sentry(config.SENTRY_URL)

log.info("starting yeller server")

public_cors = CORS(allow_all_origins=True,
                   allow_all_headers=True, allow_all_methods=True)


def generic_error_handler(ex, req, resp, params):
    if not isinstance(ex, falcon.HTTPError):
        log.exception("Internal Service Error")
        raise falcon.HTTPInternalServerError(
            "Internal Server Error", traceback.format_exc())


api = falcon.API(middleware=[public_cors.middleware, MultipartMiddleware()])
api.add_error_handler(Exception, generic_error_handler)
api.add_route("/{db}/{collection}", DbResource())
api.add_route("/query/{db}/{collection}", DbQuery())
api.add_route("/count/{db}/{collection}", DbCount())
api.add_route("/upload_file", UploadFile())
api.add_route('/upload_url', UploadURL())
api.add_route('/deploy_model', DeployModel())
api.add_route('/relabel', RelabelResource())