from yeller.classes.mongo import MongoHeler
from yeller.classes.sqs import SQS
from yeller.config import config
from yeller.logger import log

mongo_helper = MongoHeler()

class PreClassifyWorker(SQS):

    def __init__(self):
        super().__init__(config.SQS_PRECLASSIFY)

    def process_messages(self, messages):
        for m in messages:
            item = m['Records'][0]
            event_name = item.get('eventName', None)
            if "ObjectCreated" in event_name:
                self.process_put(item)

    def process_put(self, item):
        bucket_name = item.get('s3', {}).get('bucket', {}).get('name', None)
        key = item.get('s3', {}).get('object', {}).get('key', None)

        doc = {"bucket_name": bucket_name, "key": key}

        split_key = key.split("/")
        db = split_key[0]
        collection = split_key[1]

        log.info("writing message to {}.{}: {}".format(db, collection, doc))
        mongo_helper.prepare_for_write(doc)
        mongo_helper.get_collection(db, collection).insert_one(doc)
