import Ember from 'ember';

const tempContent = {
  background: 'assets/teambg1.jpg',
  logo: 'assets/teamlogo1.png',
  name: 'Evil Geniuses',
};

export default Ember.Component.extend({
  settings: {
    min: 380,
    margin: 25,
    ratio: 425/120,
    item: 'teams__item',
  },
  content: [tempContent, tempContent, tempContent, tempContent, tempContent, tempContent],
  sizeInfo: Ember.computed('content', 'settings', 'contentWidth', function(){
    const settings = this.get('settings');
    let totalWidth = this.get('contentWidth');
    let numPerRow = Math.floor(totalWidth/settings.min);
    if(numPerRow === 0){
      numPerRow = 1;
    }
    let contentSpace = totalWidth - ((numPerRow - 1) * settings.margin);
    let width = contentSpace/numPerRow;
    let height = width * (1/settings.ratio);
    return {
      width,
      height,
      numPerRow,
      totalWidth,
    };
  }),
  displayContent: Ember.computed('sizeInfo', 'content', function(){
    const content = this.get('content');
    const settings = this.get('settings');
    let results = [];
    let info = this.get('sizeInfo');
    let lastRowAmount = content.length % info.numPerRow;
    if(lastRowAmount === 0){
      lastRowAmount = info.numPerRow;
    }
    let classSize = settings.min/info.width < 0.75 ? 'full' : 'small';
    let baseClassString = `${settings.item} ${classSize}`;

    for(let i = 0; i < content.length; i++){
      let item = content[i];
      let top = i < info.numPerRow;
      let bottom = lastRowAmount >= content.length - i;
      let start = i % info.numPerRow === 0;
      let end = i % info.numPerRow === info.numPerRow - 1;

      let classString = baseClassString;
      if(top){classString += ' top';}
      if(bottom){classString += ' bottom';}
      if(start){classString += ' start';}
      if(end){classString += ' end';}

      let styleString = `
        width:${info.width}px;
        height:${info.height}px;
        line-height: ${info.height}px;
        background-image:url('${item.background}');`;

      results.push({
        content: item,
        classString: Ember.String.htmlSafe(classString),
        styleString: Ember.String.htmlSafe(styleString),
      });
    }
    return results;
  }),

  init(){
    this._super(...arguments);

    //resize setup plus handler
    window.setTimeout(() => {
      this.handleResize();
    });
    window.$(window).on('resize', Ember.run.bind(this, this.handleResize));
  },

  handleResize(){
    let width = window.$('.teams__container').width();
    this.set('contentWidth', width);
  },
});
