import * as React from 'react';
import * as ReactDOM from 'react-dom';
import * as _ from 'lodash';
/* import { BrowserRouter as Router, Route, Link } from 'react-router-dom'; */

class Cheermote extends React.Component {
  render() {
    const { size, variant, style } = this.props;
    const images = _.map(this.props.values, value => {
      const url = `${this.props.baseUrl}/${variant}/${style}/${value}/${size}.gif`;
      return <img
        key={url}
        src={url}
      />;
    });

    return <div className="cheermote">
      <span className="name">{this.props.name}</span>
      {images}
    </div>;
  }
}

Cheermote.defaultProps = {
  size: 1,
  variant: 'light',
  style: 'animated'
}

class CheermoteInspector extends React.Component {
  constructor(...args) {
    super(args[0]);

    this.state = {
      size: 1,
      variant: 'light',
      baseUrl: this.props.baseUrl,
      cheermotes: this.props.cheermotes,
      background: 'white',
      color: 'purple'
    };
  }

  setBaseUrl(e) {
    this.setState({ baseUrl: e.target.value });
  }

  setCheermotes(e) {
    this.setState({ cheermotes: e.target.value });
  }

  setSize(e) {
    this.setState({ size: e.target.value });
  }

  setBackground(e) {
    let background = e.target.value;
    let color;
    switch(background) {
      case '#0C0E13':
        color = 'white';
        break;
      default:
        color = 'purple';
    }
    this.setState({ background, color });
  }

  setVariant(e) {
    const variant = e.target.value;
    this.setState({ variant });
  }

  render() {
    const classes = [''];

    const cheermotes = _.map(this.state.cheermotes.split(','), name => {
      return <Cheermote
        key={name}
        name={name}
        variant={this.state.variant}
        size={this.state.size}
        baseUrl={`${this.state.baseUrl}/${name}`}
        values={this.props.values}
      />;
    });

    console.log(this.state.color);
    return <div className={classes.join(' ')}
      style={{
        background: this.state.background,
        color: this.state.color
      }}>
      <input type="text" name="baseUrl" value={this.state.baseUrl} onChange={this.setBaseUrl.bind(this)} />
      <input type="text" name="cheermotes" value={this.state.cheermotes} onChange={this.setCheermotes.bind(this)} />
      <select onChange={this.setSize.bind(this)} value={this.state.size}>
        {_.map([1,1.25,1.5,2,3,4], size =>
            <option value={size}>{size}</option>)}
      </select>
      background
      <select onChange={this.setBackground.bind(this)} value={this.state.background}>
        {_.map(['#0C0E13', 'white'], background =>
            <option value={background}>{background}</option>)}
      </select>
      variant
      <select onChange={this.setVariant.bind(this)} value={this.state.variant}>
        {_.map(['light', 'dark'], variant =>
            <option value={variant}>{variant}</option>)}
      </select>
      {this.props.children}
      <div className="cheermotes">{cheermotes}</div>
    </div>;
  }
}

const url = new URL(window.location.href);

CheermoteInspector.defaultProps = {
  baseUrl: url.searchParams.get('base_url') || 'https://d3aqoihi2n8ty8.cloudfront.net/hgc2017/actions',
  cheermotes: url.searchParams.get('cheermotes') || 'blsm,dig,estar,fnc,kt,lfive,mvpb,nav,pd,rpg,rvn,spt,tf,tl,trk,wkg,ce,eid,exp,gfe,ldy,mty,mvpm,nt,roll,rrr,soa,sss,tgg,tmp,ts,zlt',
  values: [1, 100, 1000, 5000, 10000],
  variants: ['light', 'dark']
}

ReactDOM.render(
  <CheermoteInspector />,
  document.getElementById('main')
);
