'use strict';

const path = require('path');
const process = require('process');
const webpack = require('webpack');
const HtmlWebpackPlugin = require('html-webpack-plugin');
let basePath = __dirname;

module.exports = {
  name: 'cheermote-inspector',
  entry: './index.jsx',
  target: 'web', // default
  devServer: {
    inline: true,
    hot: true,
    disableHostCheck: true,
    port: 3300
  },
  plugins: [
    new HtmlWebpackPlugin({
      title: 'Cheermote Inspector',
      template: 'index.ejs'
    }),
    new webpack.HotModuleReplacementPlugin()
  ],
  output: {
    path: path.join(process.cwd(), '/dist/'),
    publicPath: '/cheermote-inspector',
    filename: 'bundle-[hash].js'
  },
  resolve: {
    alias: {
      config: path.join(__dirname, 'config', process.env.NODE_ENV || 'development')
    },
    extensions: ['.js', '.jsx'],
    modules: [
      path.join(__dirname, 'app'),
      path.join(__dirname, 'node_modules')
    ]
  },
  module: {
    rules: [{
      test: /\.jsx?$/,
      exclude: /(node_modules|bower_components)/,
      use: {
        loader: 'babel-loader',
        options: {
          presets: ['env', 'react']
        }
      }
    }, {
      test: /\.(gif|jpg|png|svg)$/,
      loader: 'file-loader'
    }]
  },
  devtool: process.env.NODE_ENV === 'development' ? 'inline-source-map' : 'source-map',
};
