### Tourney (Esports CMS) Deployment

##### *TL;DR*

 - Have ruby.
 - Have valid AWS access credentials set up for our two accounts as `twitch-esports-aws` (prod) and `twitch-esports-dev` (staging)
 - Clone https://git-aws.internal.justin.tv/esports/ecs-deploy and `gem build ecs-deploy.gemspec && gem install ecs-deploy-0.2.1.gem`
 - Go to your favorite service directory
 - `./build.sh <staging|production>` and answer yes for build, push.
 - `ecs-deploy -e <staging|production>` (uses deploy.yml to figure things out)

##### Where is everything?

Go to [Isengard](https://isengard.amazon.com), where you should see both twitch-esports-aws and twitch-esports-dev accounts w/ administrator or developer access roles. Click those, it'll federate you into that account for that role.

The EC2 Container Service is where services live. Services log to Cloudfront, you can search their log groups or check logs for a specific service container there (which is also linked from the task on ECS.)

##### How'd things get there?

Terraform. Everything is done in terraform.

 - https://git-aws.internal.justin.tv/esports/terraform has account-specific things, with systems (peering and whatnot) in `accounts/*/systems`
 - Every service has its own `terraform` folder for staging and production

The first uses terraform remote backends, for which you will need Terraform 0.9+ while the latter all use local storage, so make sure you always commit your new `terraform.tfstate*` when you make changes.

*ALWAYS* run `terraform plan` and *VERY CAREFULLY INSPECT ANY CHANGES IT PROPOSES* before running `terraform apply`

Note: currently, due to some data sources in services, you'll see nonsensical modifications (marked by `~`) that won't actually do anything but appear in every `terraform plan` because ..that's how things are.

##### I fucked up, how do I roll back?

`ecs-deploy` can't do that for you yet, it just bumps task definitions to roll out the `latest` tags on our container images.

You can see all previous Task Definitions on the ECS dashboard. *However*, rolling back to one of them won't do anything currently, as all of them deploy the `latest` image. So in order to roll back to a specific image, you will have to tag that image with `latest` and then roll back to a previous task definition or simply bump it again.

On ECS, check Repositories. Every image we've ever pushed will be there. You can sort by push date.

To tag one of these as `latest`, you will have to pull it locally, like this (`@sha256:...` as listed on the repository)

`docker pull 157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-passport@sha256:952eadb0c9a5e7c7ba41c4aac32c14f2b25266d4a6c9a0853ef8b0b8839eda28`

You can then tag it, and push the tag (this tags it as `testing`, beware the copy/paste!), like this:

```
docker tag 157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-passport@sha256:952eadb0c9a5e7c7ba41c4aac32c14f2b25266d4a6c9a0853ef8b0b8839eda28 157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-passport:testing`
docker push 157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-passport:testing
```
