# The Esports Database!

This service should ideally contain every bit of information about every entity within esports. Teams, Players, their related data such as transfers, tournaments, matches and series and much more.

## Run it.

 * Install [docker compose 1.9+](https://docs.docker.com/compose/install/), docker engine 1.12+ and `docker-compose up`!

### Do things in containers!

It's recommended that you create yourself a couple of bash aliases (or whichever shell flavor you prefer) to avoid typing the same thing a thousand times. Here's our favorites:

```
alias dc='docker-compose'
alias dcr='docker-compose run $(basename "$PWD") bundle exec'
```

### What it does and doesn't do

EDB *does*:

 * store the consumer view on most entities that exist in esports, e.g. it knows who won (or tied) a Match, but it does not care why.

EDB *does not*:

 * deal with game specific data - it stores it in raw (JSON) format for other services to digest and use.

### Architectural Notes

#### Series

Series can contain any number of matches, between any number of opponents. It uses STI to narrow this down to common formats.

##### Series::Bo5

 * it will always contain at least 3 matches and at most 5 matches.
 * it is always between two opponents, never more or less.
 * it requires at least one match to be created.
 * if created with one match, it will build (but not persist) 4 additional matches with the same opponents (these are included in API output with a `null` id)
 * once any opponent has won 3 matches, a winner is determined (as returned by `#winner`) and no more matches will be automatically appended.

##### Series::Bo3

Works exactly like Bo5, with 2 matches being the win condition.

##### Series::Bo1

Works like Bo5, but never builds any matches. Requires the one match to be played at creation.

##### Series::Proleague

 * uses the [Proleague Format](http://wiki.teamliquid.net/starcraft2/Proleague_Format)
 * can have any number of matches and as such, requires all matches to be provided on creation.
 * it is always between two opponent teams.
 * if using anything but `Team` as opponents for matches, requires opponent teams to be provided for the Series.
 * if match count is even, it will add an ace match as long as the score does not provide a winner.
 * if `settings.blindpick` is true, output will not include the match opponents until both sides are set.

To elaborate: if you create Proleague series that has 4 matches, the ace match will be appended until the score is 3-?

Setting blindpick lineups works by adding/updating the opponent index corresponding to the series opponent. There will be an endpoint specifically handling this that receives player order and creates/updates match_teams accordingly.

### Curse Integration

You need the **Curse server ID** (a UUID) and an **auth token**.
The easiest way I've found to get these is to load the [Curse web app](https://app.twitch.tv), open Chrome developer tools, and snoop on your own HTTP requests as you connect to a server.

**Auth Token:** After some initial session setup, pretty much any request to `curseapp.net` will include an `AuthenticationToken` header.

**Server ID:** Look for GETs to a UUID resource that include the `?showDeletedChannels=false` param:<br/> `https://groups-v1.curseapp.net/groups/`**{server_id}**`?showDeletedChannels=false`<br/>
If you want to be super sure you got the right one, go to the server lobby (the `#lobby` text channel), click the invite button, and look for the POST to `invites`:<br/>
`https://groups-v1.curseapp.net/servers/`**{server_id}**`/invites`

Add these to your `.env.local` before you run the Rails server:
```
CURSE_SERVER='${server_id}'
CURSE_AUTH_TOKEN='${auth_token}'
```
