class V1::EventsController < V1::BaseController
  include Authorization
  require_admin! only: [:create, :update, :destroy]

  def index
    filters = filter_params
    events = Event
    events = events.where('starts_at >= ?', filters.delete(:from)) if filters[:from]
    events = events.where('starts_at <= ?', filters.delete(:to)) if filters[:to]
    events = events.order('starts_at ASC').filter(filters)
    render json: events
  end

  def show
    render json: event
  end

  def create
    render json: Event.create!(create_params)
  end

  def update
    event.update!(create_params)
    render json: event
  end

  def destroy
    event.destroy!
    render json: event
  end

  private

  def event
    @event ||= Event.friendly.find(params.require(:id))
  end

  def filter_params
    return @filter_params if @filter_params

    fparams = params.permit(:on, :from, :to, :limit, :offset, :ids, ids: [])

    if fparams[:on]
      if fparams[:from] || fparams[:to]
        raise ActionController::BadRequest.new('cannot combine "on" with "from" or "to"')
      end
      time = parse_time(fparams.delete(:on))
      fparams[:from] = time.beginning_of_day
      fparams[:to] = time.end_of_day
    end

    if fparams[:from]
      fparams[:from] = parse_time(fparams[:from]).beginning_of_day
    end
    if fparams[:to]
      fparams[:to] = parse_time(fparams[:to]).end_of_day
    end

    @filter_params = fparams
  end

  def create_params
    return @create_params if @create_params
    if params[:logo] && ![ActionController::Parameters,
                          ActionDispatch::Http::UploadedFile].include?(params[:logo].class)
      raise ActionController::BadRequest.new('Logo must be an image')
    end
    @create_params = params.permit(:title, :slug, :description, :starts_at,
                                   :twitch_url, :logo, :remote_logo_url)
  end

  def parse_time(input)
    return input if input.is_a?(Time)
    Time.parse(input)
  rescue ArgumentError => e
    raise ActionController::BadRequest.new("invalid time/date: #{input.inspect}")
  end
end
