class V1::GamesController < V1::BaseController
  include Authorization

  require_admin! only: [:create, :update, :destroy]

  def index
    games = Game.filter(filter_params)
    render json: games
  end

  def show
    render json: game
  end

  def create
    game = Game.create!(game_params)
    render json: game
  end

  def update
    game.update!(game_params)
    render json: game
  end

  def destroy
    game.destroy!
    render json: game
  end

  private

  def game
    @game ||= Game.find(params[:id])
  end

  def game_params
    # Actual image format/mime validation happens in CarrierWave, but it
    # simply ignores strings and other invalid inputs.
    if params[:cover] && ![ActionController::Parameters,
                          ActionDispatch::Http::UploadedFile].include?(params[:cover].class)
      raise ActionController::BadRequest.new('Logo must be an image')
    end

    params.permit(:name, :abbr, :cover, :remote_cover_url)
  end

  def filter_params
    params.permit(:limit, :offset, :ids, ids: [])
  end
end
