class V1::LeaguesController < V1::BaseController
  include Authorization
  require_admin! except: [:index, :show]

  def index
    render json: League.filter(filter_params)
  end

  def show
    render json: league
  end

  def create
    render json: League.create!(create_params)
  end

  def update
    league.update!(create_params)
    render json: league
  end

  def destroy
    league.destroy!
    render json: league
  end

  private

  def league
    @league ||= League.find(params[:id])
  end

  def filter_params
    params.permit(:limit, :offset, :ids, ids: [])
  end

  def create_params
    params.permit(:name)
  end
end
